/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.align;

import com.whitemagicsoftware.keentype.align.KtPreamble;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.command.KtBaseToksChecker;
import com.whitemagicsoftware.keentype.command.KtBraceNesting;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtRightBraceToken;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import java.util.Vector;

public class KtPreambleScanning
extends KtBaseToksChecker
implements KtBraceNesting {
    private final Vector<KtPreamble.Entry> entries = new Vector();
    private KtTokenList.KtBuffer buf = new KtTokenList.KtBuffer();
    private KtTokenList uPart = KtTokenList.NULL;
    private int loopIndex = -1;
    private int braceNesting = 0;
    private final KtTokenList crAndBrace;

    public KtPreambleScanning(KtToken source, KtToken frozenCr) {
        super("OuterInPreamble", "EOFinPreamble", source);
        KtToken[] toks = new KtToken[]{frozenCr, KtRightBraceToken.TOKEN};
        this.crAndBrace = new KtTokenList(toks);
    }

    public boolean balanced() {
        return this.braceNesting == 0;
    }

    public void append(KtToken tok) {
        this.buf.append(tok);
    }

    public void finishHalf() {
        this.uPart = this.buf.toTokenList();
        this.buf = new KtTokenList.KtBuffer();
    }

    public void finishRecord(KtGlue skip) {
        this.entries.add(new KtPreamble.Entry(this.uPart, this.buf.toTokenList(), skip));
        this.uPart = KtTokenList.NULL;
        this.buf = new KtTokenList.KtBuffer();
    }

    public boolean setLoopIndex() {
        if (this.loopIndex >= 0) {
            return false;
        }
        this.loopIndex = this.entries.size();
        return true;
    }

    public KtPreamble toPreamble(KtGlue firstSkip, String skipName, KtToken endTemplate) {
        Object[] records = new KtPreamble.Entry[this.entries.size()];
        this.entries.copyInto(records);
        return new KtPreamble(firstSkip, skipName, endTemplate, (KtPreamble.Entry[])records, this.loopIndex);
    }

    @Override
    public void adjust(int count) {
        this.braceNesting += count;
    }

    @Override
    protected void tryToFix() {
        KtCommand.insertList(this.crAndBrace);
    }

    @Override
    protected void reportRunAway() {
        KtCommand.runAway("preamble", this.buf);
    }
}

