/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.command.KtAssignPrim;
import com.whitemagicsoftware.keentype.command.KtToken;

public class KtInteractionPrim
extends KtAssignPrim {
    public static final int BATCH = 0;
    public static final int NONSTOP = 1;
    public static final int SCROLL = 2;
    public static final int ERROR_STOP = 3;
    public static final String[] names = new String[]{"batchmode", "nonstopmode", "scrollmode", "errorstopmode"};
    private static int value = 3;
    private final int mode;

    public static int get() {
        return value;
    }

    public static boolean isSilent() {
        return value == 0;
    }

    public static boolean isInteractive() {
        return value > 1;
    }

    public static boolean isErrStopping() {
        return value == 3;
    }

    public static void setScroll() {
        if (value > 2) {
            value = 2;
        }
    }

    public static void set(int val) {
        value = val;
        KtInteractionPrim.setTermEnable(value != 0);
    }

    public static void set(String mnem) {
        for (int i = 0; i < names.length; ++i) {
            if (!mnem.equals(names[i])) continue;
            KtInteractionPrim.set(i);
            return;
        }
        throw new RuntimeException("Invalid interaction: " + mnem);
    }

    public KtInteractionPrim(String name, int mode) {
        super(name);
        this.mode = mode;
    }

    @Override
    protected void assign(KtToken src, boolean glob) {
        normLog.endLine();
        KtInteractionPrim.set(this.mode);
    }

    static {
        String prop = System.getProperty("nts.interaction");
        if (prop != null) {
            KtInteractionPrim.set(prop);
        } else {
            KtInteractionPrim.set(3);
        }
    }
}

