/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.noad;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.noad.KtCharField;
import com.whitemagicsoftware.keentype.noad.KtConverter;
import com.whitemagicsoftware.keentype.noad.KtEgg;
import com.whitemagicsoftware.keentype.noad.KtEmptyField;
import com.whitemagicsoftware.keentype.noad.KtField;
import com.whitemagicsoftware.keentype.noad.KtNoadList;
import com.whitemagicsoftware.keentype.noad.KtNoadListField;
import com.whitemagicsoftware.keentype.noad.KtOrdNoad;
import com.whitemagicsoftware.keentype.noad.KtScriptableNoad;
import com.whitemagicsoftware.keentype.noad.KtStItalNodeEgg;
import com.whitemagicsoftware.keentype.noad.KtStSimpleNodeEgg;
import com.whitemagicsoftware.keentype.noad.KtSubScriptNoad;
import com.whitemagicsoftware.keentype.noad.KtSuperScriptNoad;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtIntVKernNode;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtVBoxNode;
import com.whitemagicsoftware.keentype.node.KtVShiftNode;

public class KtAccentNoad
extends KtScriptableNoad {
    protected final KtCharField accent;
    protected final KtField nucleus;

    public KtAccentNoad(KtCharField accent, KtField nucleus) {
        this.accent = accent;
        this.nucleus = nucleus;
    }

    protected String getDesc() {
        return "accent";
    }

    @Override
    public boolean isOrdinary() {
        return true;
    }

    protected byte spacingType() {
        return 0;
    }

    @Override
    public boolean isJustChar() {
        return this.nucleus.isJustChar();
    }

    @Override
    public void addOn(KtLog log, KtCntxLog cntx) {
        log.addEsc(this.getDesc()).add(this.accent);
        this.nucleus.addOn(log, cntx, '.');
    }

    @Override
    public KtEgg convert(KtConverter conv) {
        return this.sharedConvert(conv, KtEmptyField.FIELD, KtEmptyField.FIELD);
    }

    @Override
    public KtEgg convertWithScripts(KtConverter conv, KtField sup, KtField sub) {
        return this.nucleus.isJustChar() ? this.sharedConvert(conv, sup, sub) : super.convertWithScripts(conv, sup, sub);
    }

    private KtEgg sharedConvert(KtConverter conv, KtField sup, KtField sub) {
        if (this.accent.convertedBy(conv) != KtNode.NULL) {
            KtDimen skew = this.nucleus.skewAmount(conv);
            KtNode nuclNode = this.nucleus.cleanBox(conv, (byte)1);
            KtDimen height = nuclNode.getHeight();
            KtDimen width = nuclNode.getWidth();
            KtDimen delta = height.min(this.accent.xHeight(conv));
            KtBox accBox = this.accent.fittingTo(conv, width);
            if (accBox != KtBox.NULL) {
                if (!sup.isEmpty() || !sub.isEmpty()) {
                    KtScriptableNoad noad = new KtOrdNoad(this.nucleus);
                    if (!sub.isEmpty()) {
                        noad = new KtSubScriptNoad(noad, sub);
                    }
                    if (!sup.isEmpty()) {
                        noad = new KtSuperScriptNoad(noad, sup);
                    }
                    nuclNode = new KtNoadListField(new KtNoadList(noad)).cleanBox(conv, (byte)0);
                    delta = delta.plus(nuclNode.getHeight().minus(height));
                    height = nuclNode.getHeight();
                }
                KtNodeList list = new KtNodeList(3);
                KtDimen shift = width.minus(accBox.getWidth()).halved().plus(skew);
                accBox = accBox.pretendSizesCopy(new KtBoxSizes(accBox.getHeight(), KtDimen.ZERO, accBox.getDepth(), KtDimen.ZERO));
                list.append(KtVShiftNode.shiftingRight(accBox, shift)).append(new KtIntVKernNode(delta.negative())).append(nuclNode);
                KtBox box = KtVBoxNode.packedOf(list);
                if (box.getHeight().lessThan(height)) {
                    KtNodeList list2 = new KtNodeList(4);
                    list2.append(new KtIntVKernNode(height.minus(box.getHeight()))).append(list);
                    box = KtVBoxNode.packedOf(list2);
                }
                box = box.pretendSizesCopy(new KtBoxSizes(box.getHeight(), nuclNode.getWidth(), box.getDepth(), nuclNode.getLeftX()));
                return new KtStSimpleNodeEgg(box, this.spacingType());
            }
        }
        return new KtStItalNodeEgg(this.nucleus.convertedBy(conv), this.spacingType());
    }
}

