/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.noad;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtCntxLoggable;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.noad.KtConverter;
import com.whitemagicsoftware.keentype.noad.KtEgg;
import com.whitemagicsoftware.keentype.noad.KtField;
import com.whitemagicsoftware.keentype.noad.KtOperator;
import com.whitemagicsoftware.keentype.noad.KtOperatorEgg;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtHBoxNode;
import com.whitemagicsoftware.keentype.node.KtHShiftNode;
import com.whitemagicsoftware.keentype.node.KtMathWordBuilder;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtTreatNode;

public class KtCharField
extends KtField
implements KtLoggable,
KtCntxLoggable {
    public static final KtCharField NULL = null;
    private final byte fam;
    private final KtCharCode code;

    public KtCharField(byte fam, KtCharCode code) {
        this.fam = fam;
        this.code = code;
    }

    @Override
    public void addOn(KtLog log) {
        log.addEsc("fam").add(this.fam).add(' ').add(this.code);
    }

    @Override
    public void addOn(KtLog log, KtCntxLog cntx) {
        this.addOn(log);
    }

    @Override
    public void addOn(KtLog log, KtCntxLog cntx, char p) {
        cntx.addOn(log, this, p);
    }

    @Override
    public boolean isJustChar() {
        return true;
    }

    @Override
    public KtDimen skewAmount(KtConverter conv) {
        return conv.skewAmount(this.fam, this.code);
    }

    @Override
    public KtNode convertedBy(KtConverter conv) {
        return conv.fetchCharNode(this.fam, this.code);
    }

    public KtBox fittingTo(KtConverter conv, KtDimen width) {
        return conv.fetchFittingWidthBox(this.fam, this.code, width);
    }

    public KtDimen xHeight(KtConverter conv) {
        return conv.getXHeight(this.fam);
    }

    @Override
    public KtNode cleanBox(KtConverter conv, byte how) {
        return KtCharField.packedWithItalCorr(conv.fetchCharNode(this.fam, this.code, how));
    }

    private static KtNode packedWithItalCorr(KtNode node) {
        if (node == KtNode.NULL) {
            return KtHBoxNode.EMPTY;
        }
        KtHBoxNode box = KtHBoxNode.packedOf(node);
        KtDimen ital = node.getItalCorr();
        return ital == KtDimen.NULL ? box : box.pretendingWidth(box.getWidth().plus(ital));
    }

    private static KtOperator makeOperator(KtNode node, KtConverter conv) {
        KtDimen middle = conv.getDimPar(16);
        KtDimen shift = (node == KtNode.NULL ? KtDimen.ZERO : node.getHeight().max(KtDimen.ZERO).minus(node.getDepth().max(KtDimen.ZERO)).halved()).minus(middle);
        return new KtCharOperator(node, shift);
    }

    @Override
    public KtOperator makeOperator(KtConverter conv, boolean larger) {
        return KtCharField.makeOperator(larger ? conv.fetchLargerNode(this.fam, this.code) : conv.fetchCharNode(this.fam, this.code), conv);
    }

    @Override
    public KtMathWordBuilder getMathWordBuilder(KtConverter conv, KtTreatNode proc) {
        return conv.getWordBuilder(this.fam, proc);
    }

    @Override
    public byte wordFamily() {
        return this.fam;
    }

    @Override
    public void contributeToWord(KtMathWordBuilder word) {
        word.add(this.code);
    }

    @Override
    public KtOperator takeLastOperator(KtMathWordBuilder word, KtConverter conv, boolean larger) {
        return KtCharField.makeOperator(larger ? word.takeLastLargerNode() : word.takeLastNode(), conv);
    }

    protected static class KtCharOperator
    implements KtOperator {
        private final KtNode node;
        private final KtDimen shift;

        public KtCharOperator(KtNode node, KtDimen shift) {
            this.node = node;
            this.shift = shift;
        }

        @Override
        public KtNode getNodeToBeLimited() {
            KtNode box = KtCharField.packedWithItalCorr(this.node);
            return this.shift.isZero() ? box : KtHBoxNode.packedOf(KtHShiftNode.shiftingDown(box, this.shift));
        }

        @Override
        public KtEgg getEggToBeScripted(byte spType) {
            return new KtOperatorEgg(this.node, this.shift, spType);
        }

        @Override
        public KtDimen getItalCorr() {
            return this.node == KtNode.NULL ? KtDimen.NULL : this.node.getItalCorr();
        }
    }
}

