/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.node.KtLinesShape;

public class KtHangIndent
implements KtLinesShape {
    private final int boundary;
    private final KtDimen firstWidth;
    private final KtDimen firstIndent;
    private final KtDimen secondWidth;
    private final KtDimen secondIndent;

    public KtHangIndent(int b, KtDimen fw, KtDimen fi, KtDimen sw, KtDimen si) {
        this.boundary = b;
        this.firstWidth = fw;
        this.firstIndent = fi;
        this.secondWidth = sw;
        this.secondIndent = si;
    }

    public KtHangIndent(KtDimen sw, KtDimen si) {
        this(0, KtDimen.ZERO, KtDimen.ZERO, sw, si);
    }

    @Override
    public boolean isFinal(int idx) {
        return idx >= this.boundary;
    }

    @Override
    public KtDimen getWidth(int idx) {
        return idx < this.boundary ? this.firstWidth : this.secondWidth;
    }

    @Override
    public KtDimen getIndent(int idx) {
        return idx < this.boundary ? this.firstIndent : this.secondIndent;
    }

    public static KtLinesShape makeShape(int ha, KtDimen hi, KtDimen hs) {
        KtDimen size;
        KtDimen ind;
        if (hi.isZero()) {
            return new KtHangIndent(hs, KtDimen.ZERO);
        }
        if (hi.lessThan(0)) {
            ind = KtDimen.ZERO;
            size = hs.plus(hi);
        } else {
            ind = hi;
            size = hs.minus(hi);
        }
        return ha < 0 ? new KtHangIndent(-ha, size, ind, hs, KtDimen.ZERO) : new KtHangIndent(ha, hs, KtDimen.ZERO, size, ind);
    }
}

