/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tfm;

import java.util.Vector;

public class KtIndexMultimap {
    private final Vector<KtPair> data = new Vector();

    protected final int size() {
        return this.data.size();
    }

    protected final KtPair at(int i) {
        return this.data.elementAt(i);
    }

    protected final void insert(KtPair p, int i) {
        this.data.insertElementAt(p, i);
    }

    protected final int search(int key) {
        int beg = 0;
        int end = this.size();
        while (beg < end) {
            int med = (beg + end) / 2;
            KtPair p = this.at(med);
            if (key < p.key) {
                end = med;
                continue;
            }
            if (key > p.key) {
                beg = med + 1;
                continue;
            }
            return med;
        }
        return beg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int key, int val) {
        Vector<KtPair> vector = this.data;
        synchronized (vector) {
            int pos;
            for (pos = this.search(key); pos < this.size() && this.at((int)pos).key == key; ++pos) {
            }
            this.insert(new KtPair(key, val), pos);
        }
    }

    public KtEnum forKey(int key) {
        return new KtEnum(key);
    }

    protected static class KtPair {
        int key;
        int val;

        KtPair(int k, int v) {
            this.key = k;
            this.val = v;
        }
    }

    public class KtEnum {
        private int pos;
        private final int key;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KtEnum(int k) {
            Vector<KtPair> vector = KtIndexMultimap.this.data;
            synchronized (vector) {
                this.key = k;
                this.pos = KtIndexMultimap.this.search(this.key);
                while (this.pos > 0 && KtIndexMultimap.this.at((int)(this.pos - 1)).key == this.key) {
                    --this.pos;
                }
            }
        }

        public final boolean hasMore() {
            return this.pos < KtIndexMultimap.this.size() && KtIndexMultimap.this.at((int)this.pos).key == this.key;
        }

        public final int next() {
            return KtIndexMultimap.this.at((int)this.pos++).val;
        }
    }
}

