/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class PVK {
    private static final byte[] RSA2_KEY_MAGIC = "RSA2".getBytes();

    public static PrivateKey parse(File file, String password) throws GeneralSecurityException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate((int)file.length());
        try (FileInputStream in = new FileInputStream(file);){
            in.getChannel().read(buffer);
            PrivateKey privateKey = PVK.parse(buffer, password);
            return privateKey;
        }
    }

    public static PrivateKey parse(ByteBuffer buffer, String password) throws GeneralSecurityException {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.rewind();
        long magic = (long)buffer.getInt() & 0xFFFFFFFFL;
        if (2964713758L != magic) {
            throw new IllegalArgumentException("PVK header signature not found");
        }
        buffer.position(buffer.position() + 4);
        int keyType = buffer.getInt();
        boolean encrypted = buffer.getInt() != 0;
        int saltLength = buffer.getInt();
        int keyLength = buffer.getInt();
        byte[] salt = new byte[saltLength];
        buffer.get(salt);
        byte btype = buffer.get();
        byte version = buffer.get();
        buffer.position(buffer.position() + 2);
        int keyalg = buffer.getInt();
        byte[] key = new byte[keyLength - 8];
        buffer.get(key);
        if (encrypted) {
            key = PVK.decrypt(key, salt, password);
        }
        return PVK.parseKey(key);
    }

    private static byte[] decrypt(byte[] encoded, byte[] salt, String password) throws GeneralSecurityException {
        String algorithm;
        byte[] hash = PVK.deriveKey(salt, password);
        SecretKeySpec strongKey = new SecretKeySpec(hash, 0, 16, algorithm = "RC4");
        byte[] decoded = PVK.decrypt(strongKey, encoded);
        if (PVK.startsWith(decoded, RSA2_KEY_MAGIC)) {
            return decoded;
        }
        Arrays.fill(hash, 5, hash.length, (byte)0);
        SecretKeySpec weakKey = new SecretKeySpec(hash, 0, 16, algorithm);
        decoded = PVK.decrypt(weakKey, encoded);
        if (PVK.startsWith(decoded, RSA2_KEY_MAGIC)) {
            return decoded;
        }
        throw new IllegalArgumentException("Unable to decrypt the PVK key, please verify the password");
    }

    private static byte[] decrypt(SecretKey key, byte[] encoded) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(2, key);
        return cipher.doFinal(encoded);
    }

    private static byte[] deriveKey(byte[] salt, String password) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA1");
        digest.update(salt);
        if (password != null) {
            digest.update(password.getBytes());
        }
        return digest.digest();
    }

    private static PrivateKey parseKey(byte[] key) throws GeneralSecurityException {
        ByteBuffer buffer = ByteBuffer.wrap(key);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (!PVK.startsWith(key, RSA2_KEY_MAGIC)) {
            throw new IllegalArgumentException("Unable to parse the PVK key, unsupported key format: " + new String(key, 0, RSA2_KEY_MAGIC.length));
        }
        buffer.position(buffer.position() + RSA2_KEY_MAGIC.length);
        int bitlength = buffer.getInt();
        BigInteger publicExponent = new BigInteger(String.valueOf(buffer.getInt()));
        int l = bitlength / 8;
        BigInteger modulus = PVK.getBigInteger(buffer, l);
        BigInteger primeP = PVK.getBigInteger(buffer, l / 2);
        BigInteger primeQ = PVK.getBigInteger(buffer, l / 2);
        BigInteger primeExponentP = PVK.getBigInteger(buffer, l / 2);
        BigInteger primeExponentQ = PVK.getBigInteger(buffer, l / 2);
        BigInteger crtCoefficient = PVK.getBigInteger(buffer, l / 2);
        BigInteger privateExponent = PVK.getBigInteger(buffer, l);
        RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePrivate(spec);
    }

    private static BigInteger getBigInteger(ByteBuffer buffer, int length) {
        byte[] array = new byte[length + 1];
        buffer.get(array, 0, length);
        return new BigInteger(PVK.reverse(array));
    }

    private static byte[] reverse(byte[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            byte b = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = b;
        }
        return array;
    }

    private static boolean startsWith(byte[] array, byte[] prefix) {
        for (int i = 0; i < prefix.length; ++i) {
            if (prefix[i] == array[i]) continue;
            return false;
        }
        return true;
    }
}

