/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.base;

import com.whitemagicsoftware.keentype.base.KtPairKey;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class KtClassAssoc
implements Serializable {
    private final Class<?> root;
    private final HashMap<KtPairKey, Object> matrix;
    private final Vector<Class<?>> list = new Vector(10);

    public KtClassAssoc(Class<?> root, int initialSize, float loadFactor) {
        this.root = root;
        this.matrix = new HashMap(initialSize, loadFactor);
    }

    public KtClassAssoc(Class<?> root) {
        this(root, 1009, 0.5f);
    }

    public Class<?> getRoot() {
        return this.root;
    }

    public boolean recorded(Class<?> cls) {
        return this.list.contains(cls);
    }

    private void check(Class<?> cls) {
        if (!this.root.isAssignableFrom(cls)) {
            throw new RuntimeException(String.valueOf(cls) + "is not a " + String.valueOf(this.root));
        }
        if (this.list.contains(cls)) {
            throw new RuntimeException(String.valueOf(cls) + " already registered");
        }
    }

    public void record(Class<?> clazz) {
        this.check(clazz);
        if (!this.list.isEmpty()) {
            Class<?> sup = clazz.getSuperclass();
            if (!this.list.contains(sup)) {
                throw new RuntimeException("Super class (" + String.valueOf(sup) + ")  of " + String.valueOf(clazz) + " not registered");
            }
            Set<KtPairKey> keySet = this.matrix.keySet();
            KtPairKey[] inheritedKeys = new KtPairKey[keySet.size()];
            Object[] inheritedVals = new Object[keySet.size()];
            int index = 0;
            for (KtPairKey curr : keySet) {
                KtPairKey key;
                if (!curr.first.equals(sup) || this.matrix.containsKey(key = new KtPairKey(clazz, curr.second))) continue;
                inheritedKeys[index] = key;
                inheritedVals[index] = this.matrix.get(curr);
                ++index;
            }
            while (--index >= 0) {
                this.matrix.put(inheritedKeys[index], inheritedVals[index]);
            }
        }
        this.list.addElement(clazz);
    }

    public final void put(Class<?> cls, Object key, Object val) {
        this.check(cls);
        this.matrix.put(new KtPairKey(cls, key), val);
    }

    public final Object get(Class<?> cls, Object key) {
        return this.matrix.get(new KtPairKey(cls, key));
    }
}

