/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.base;

import com.whitemagicsoftware.keentype.base.KtIntProvider;
import java.io.Serializable;

public class KtNum
implements Serializable,
KtIntProvider {
    public static final KtNum NULL = null;
    public static final KtNum ZERO = KtNum.valueOf(0);
    public static final int MAX_INT_VALUE = Integer.MAX_VALUE;
    private final int value;
    private static final KtRomanDigit[] romanDigits = new KtRomanDigit[]{new KtRomanDigit('m', 1000, false), new KtRomanDigit('d', 500, false), new KtRomanDigit('c', 100, true), new KtRomanDigit('l', 50, false), new KtRomanDigit('x', 10, true), new KtRomanDigit('v', 5, false), new KtRomanDigit('i', 1, true)};

    private KtNum(int num) {
        this.value = num;
    }

    public static KtNum valueOf(int num) {
        return new KtNum(num);
    }

    @Override
    public final int intVal() {
        return this.value;
    }

    public int sign() {
        return Integer.compare(this.value, 0);
    }

    public boolean equals(int i) {
        return this.value == i;
    }

    public boolean equals(KtNum n) {
        return this.value == n.intVal();
    }

    public boolean lessThan(int i) {
        return this.value < i;
    }

    public boolean lessThan(KtNum n) {
        return this.value < n.intVal();
    }

    public boolean moreThan(int i) {
        return this.value > i;
    }

    public boolean moreThan(KtNum n) {
        return this.value > n.intVal();
    }

    public KtNum negative() {
        return new KtNum(-this.value);
    }

    public KtNum plus(int i) {
        return new KtNum(this.value + i);
    }

    public KtNum plus(KtNum n) {
        return new KtNum(this.value + n.intVal());
    }

    public KtNum minus(int i) {
        return new KtNum(this.value - i);
    }

    public KtNum minus(KtNum n) {
        return new KtNum(this.value - n.intVal());
    }

    public KtNum times(int i) {
        return new KtNum(this.value * i);
    }

    public KtNum times(KtNum n) {
        return new KtNum(this.value * n.intVal());
    }

    public KtNum over(int i) {
        return new KtNum(this.value / i);
    }

    public KtNum over(KtNum n) {
        return new KtNum(this.value / n.intVal());
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public String toOctString() {
        return Integer.toOctalString(this.value);
    }

    public String toHexString() {
        return Integer.toHexString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof KtNum)) return false;
        KtNum n = (KtNum)o;
        if (n.value != this.value) return false;
        return true;
    }

    public static String romanString(int n) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (true) {
            KtRomanDigit dig = romanDigits[i];
            while (n >= dig.value) {
                buf.append(dig.digit);
                n -= dig.value;
            }
            if (n <= 0) break;
            int j = i;
            while (!KtNum.romanDigits[++j].precedable) {
            }
            if (n + KtNum.romanDigits[j].value >= dig.value) {
                buf.append(KtNum.romanDigits[j].digit).append(dig.digit);
                n -= dig.value - KtNum.romanDigits[j].value;
            }
            ++i;
        }
        return buf.toString();
    }

    private static final class KtRomanDigit {
        char digit;
        int value;
        boolean precedable;

        KtRomanDigit(char d, int v, boolean p) {
            this.digit = d;
            this.value = v;
            this.precedable = p;
        }
    }

    public static interface KtProvider {
        public KtNum getNumValue();
    }
}

