/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.builder;

import com.whitemagicsoftware.keentype.builder.KtHorizBuilder;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtLanguage;
import com.whitemagicsoftware.keentype.node.KtLanguageNode;
import com.whitemagicsoftware.keentype.node.KtNodeList;

public class KtParBuilder
extends KtHorizBuilder {
    private final KtLanguage initLang;
    private KtLanguage currLang;

    public KtParBuilder(int line, KtLanguage initLang) {
        super(line);
        this.initLang = initLang;
        this.currLang = initLang;
    }

    @Override
    public String modeName() {
        return "horizontal";
    }

    @Override
    public boolean willBeBroken() {
        return true;
    }

    @Override
    public KtNodeList getParagraph() {
        return this.list;
    }

    @Override
    public KtLanguage getInitLang() {
        return this.initLang;
    }

    @Override
    public KtLanguage getCurrLang() {
        return this.currLang;
    }

    @Override
    public void setCurrLang(KtLanguage lang) {
        this.currLang = lang;
        this.addNode(new KtLanguageNode(lang));
    }

    @Override
    protected void specialShow(KtLog log, int depth, int breadth) {
        if (!this.initLang.isCommon()) {
            log.add(" (").add(this.initLang).add(')');
        }
        super.specialShow(log, depth, breadth);
    }

    @Override
    protected void specialShow(KtLog log) {
        super.specialShow(log);
        if (!this.currLang.isZero()) {
            log.add(", current language ");
            this.currLang.addNumberOn(log);
        }
    }
}

