/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.base.KtBoolPar;
import com.whitemagicsoftware.keentype.base.KtBytePar;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtContextDisplay;
import com.whitemagicsoftware.keentype.command.KtCtrlSeqToken;
import com.whitemagicsoftware.keentype.command.KtExpandable;
import com.whitemagicsoftware.keentype.command.KtInpTokChecker;
import com.whitemagicsoftware.keentype.command.KtScanToksChecker;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.command.KtTokenizer;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;

public class KtMacro
extends KtExpandable {
    private static final KtToken PAR_TOKEN = new KtCtrlSeqToken("par");
    private final KtTokenList[] mask;
    private final KtCharCode[] matchCodes;
    private final KtTokenList body;
    private final int prefixes;
    public static final int BOOLP_TRACING_MACROS = KtMacro.newBoolParam();
    private static final byte REJECT_AND_COMPLAIN = 0;
    private static final byte REJECT_ONLY = 1;
    private static final byte ACCEPT = 2;

    public KtMacro(KtTokenList[] mask, KtCharCode[] matchCodes, KtTokenList body, int prefixes) {
        this.mask = mask;
        this.matchCodes = matchCodes;
        this.body = body;
        this.prefixes = prefixes;
    }

    public KtMacro(KtTokenList body, int prefixes) {
        this.mask = new KtTokenList[0];
        this.matchCodes = null;
        this.body = body;
        this.prefixes = prefixes;
    }

    @Override
    public void doExpansion(KtToken src) {
        if (KtMacro.getConfig().getBoolParam(BOOLP_TRACING_MACROS)) {
            src.addProperlyOn(diagLog.endLine());
            this.addMask(diagLog).add(this.body).startLine();
        }
        KtTokenList[] params = null;
        if (this.mask.length > 0) {
            try {
                params = this.scanParameters(src);
            }
            catch (KtDoesNotMatch d) {
                return;
            }
        }
        KtMacro.getTokStack().cleanFinishedLists();
        KtMacro.getTokStack().push(new KtExpansion(params, src));
    }

    private KtTokenList[] scanParameters(KtToken src) throws KtDoesNotMatch {
        KtBytePar parReact = new KtBytePar((this.prefixes & 1) != 0 ? (byte)2 : 0);
        if (this.mask[0].length() != 0) {
            this.scanCompulsory(src, this.mask[0], parReact);
        }
        if (this.mask.length > 1) {
            KtTokenList[] params = new KtTokenList[this.mask.length - 1];
            for (int i = 1; i < this.mask.length; ++i) {
                KtTokenList param;
                KtTokenList.KtBuffer buf = new KtTokenList.KtBuffer(10, 10);
                KtMatchChecker mchk = new KtMatchChecker(buf, src, parReact);
                KtInpTokChecker savedChk = KtMacro.setTokenChecker(mchk);
                try {
                    if (this.mask[i].length() != 0) {
                        this.scanParam(src, buf, this.mask[i], parReact);
                    } else {
                        this.scanParam(src, buf, parReact);
                    }
                }
                catch (KtParAbort a) {
                    if (parReact.get() == 0) {
                        KtMacro.runAway("argument", buf);
                        KtMacro.backToken(a.tok);
                        KtMacro.error("RunawayArg", src);
                    }
                    throw new KtDoesNotMatch();
                }
                finally {
                    KtMacro.setTokenChecker(savedChk);
                }
                params[i - 1] = param = buf.toTokenList();
                if (!KtMacro.getConfig().getBoolParam(BOOLP_TRACING_MACROS)) continue;
                diagLog.startLine().add(this.matchCodes[i - 1]);
                diagLog.add(Character.forDigit(i, 10)).add("<-");
                param.addOn(diagLog, 1000);
                diagLog.startLine();
            }
            return params;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanCompulsory(KtToken src, KtTokenList compulsory, KtBytePar parReact) throws KtDoesNotMatch {
        KtTokenList.KtBuffer buf = new KtTokenList.KtBuffer(0);
        KtMatchChecker mchk = new KtMatchChecker(buf, src, parReact);
        KtInpTokChecker savedChk = KtMacro.setTokenChecker(mchk);
        try {
            for (int i = 0; i < compulsory.length(); ++i) {
                KtToken tok = KtMacro.nextRawToken();
                if (tok.match(compulsory.tokenAt(i))) continue;
                KtMacro.error("UseDoesntMatch", src);
                throw new KtDoesNotMatch();
            }
        }
        finally {
            KtMacro.setTokenChecker(savedChk);
        }
    }

    private void scanParam(KtToken src, KtTokenList.KtBuffer buf, KtBytePar parReact) throws KtParAbort {
        block4: {
            KtToken tok;
            do {
                if (PAR_TOKEN.match(tok = KtMacro.nextRawToken()) && parReact.get() != 2) {
                    throw new KtParAbort(tok);
                }
                if (tok.matchLeftBrace()) {
                    buf.append(tok);
                    this.addGroup(buf, parReact);
                    buf.removeLastToken();
                    buf.removeTokenAt(0);
                } else {
                    if (!tok.matchRightBrace()) continue;
                    this.reportExtraRightBrace(tok, src);
                    parReact.set((byte)0);
                }
                break block4;
            } while (tok.matchSpace());
            buf.append(tok);
        }
    }

    private void scanParam(KtToken src, KtTokenList.KtBuffer buf, KtTokenList separator, KtBytePar parReact) throws KtParAbort {
        int matchLen = separator.length();
        KtToken[] matchBuf = new KtToken[matchLen];
        int matchIdx = 0;
        int groupCnt = 0;
        while (true) {
            KtToken tok;
            block7: {
                int j;
                if ((tok = KtMacro.nextRawToken()).match(separator.tokenAt(matchIdx))) {
                    matchBuf[matchIdx++] = tok;
                    if (matchIdx < matchLen) continue;
                    if (tok.matchLeftBrace()) {
                        KtMacro.adjustBraceNesting(-1);
                    }
                    if (groupCnt != true || buf.length() < 2) break;
                    KtToken first = buf.tokenAt(0);
                    KtToken last = buf.lastToken();
                    if (!first.matchLeftBrace() || !last.matchRightBrace()) break;
                    buf.removeLastToken();
                    buf.removeTokenAt(0);
                    break;
                }
                matchBuf[matchIdx++] = tok;
                int i = 0;
                do {
                    buf.append(matchBuf[i++]);
                    if (i >= matchIdx) break block7;
                    for (j = i; j < matchIdx && matchBuf[j].match(separator.tokenAt(j - i)); ++j) {
                    }
                } while (j < matchIdx);
                System.arraycopy(matchBuf, i, matchBuf, 0, matchIdx -= i);
                continue;
            }
            matchIdx = 0;
            if (PAR_TOKEN.match(tok) && parReact.get() != 2) {
                buf.removeLastToken();
                throw new KtParAbort(tok);
            }
            if (tok.matchLeftBrace()) {
                this.addGroup(buf, parReact);
                ++groupCnt;
                continue;
            }
            if (!tok.matchRightBrace()) continue;
            buf.removeLastToken();
            this.reportExtraRightBrace(tok, src);
            parReact.set((byte)0);
        }
    }

    private void addGroup(KtTokenList.KtBuffer buf, KtBytePar parReact) throws KtParAbort {
        int balance = 1;
        while (true) {
            KtToken tok;
            if (PAR_TOKEN.match(tok = KtMacro.nextRawToken()) && parReact.get() != 2) {
                KtMacro.adjustBraceNesting(-balance);
                throw new KtParAbort(tok);
            }
            buf.append(tok);
            if (tok.matchLeftBrace()) {
                ++balance;
                continue;
            }
            if (tok.matchRightBrace() && --balance == 0) break;
        }
    }

    private void reportExtraRightBrace(KtToken tok, KtToken src) {
        KtMacro.backToken(tok);
        KtMacro.insertToken(PAR_TOKEN);
        KtMacro.adjustBraceNesting(1);
        KtMacro.error("ExtraRightBrace", src);
    }

    private KtLog addMask(KtLog log) {
        if (this.mask.length > 0) {
            log.add(this.mask[0]);
            for (int i = 1; i < this.mask.length; ++i) {
                log.add(this.matchCodes[i - 1]).add(Character.forDigit(i, 10)).add(this.mask[i]);
            }
        }
        return log;
    }

    public void addMaxOn(KtLog log, int maxCount) {
        maxCount += log.getCount();
        if (this.mask.length > 0) {
            this.mask[0].addOn(log, maxCount - log.getCount());
            for (int i = 1; i < this.mask.length && log.getCount() < maxCount; ++i) {
                log.add(this.matchCodes[i - 1]).add(Character.forDigit(i, 10));
                this.mask[i].addOn(log, maxCount - log.getCount());
            }
        }
        this.body.addOn(log, maxCount - log.getCount());
    }

    @Override
    public boolean isOuter() {
        return (this.prefixes & 2) != 0;
    }

    @Override
    public void addExpandable(KtLog log, int maxCount) {
        this.addPrefix(log);
        log.add(':');
        this.addMaxOn(log, maxCount);
    }

    @Override
    public void addExpandable(KtLog log, boolean full) {
        this.addPrefix(log);
        if (full) {
            log.add(':').endLine();
            this.addMask(log).add(this.body);
        }
    }

    private void addPrefix(KtLog log) {
        if ((this.prefixes & 1) != 0) {
            log.addEsc("long");
        }
        if ((this.prefixes & 2) != 0) {
            log.addEsc("outer");
        }
        if ((this.prefixes & 3) != 0) {
            log.add(' ');
        }
        log.add("macro");
    }

    @Override
    public boolean sameAs(KtCommand cmd) {
        if (cmd instanceof KtMacro) {
            int len;
            KtMacro mac = (KtMacro)cmd;
            if (this.prefixes == mac.prefixes && (len = this.mask.length) == mac.mask.length) {
                if (--len >= 0 && !this.mask[len].match(mac.mask[len])) {
                    return false;
                }
                while (--len >= 0) {
                    if (this.matchCodes[len].match(mac.matchCodes[len]) && this.mask[len].match(mac.mask[len])) continue;
                    return false;
                }
                return this.body.match(mac.body);
            }
        }
        return false;
    }

    private static class KtDoesNotMatch
    extends Exception {
        private KtDoesNotMatch() {
        }
    }

    private class KtExpansion
    extends KtTokenizer {
        private final KtTokenList[] params;
        private int pos = 0;
        private final KtToken src;

        public KtExpansion(KtTokenList[] params, KtToken src) {
            this.params = params;
            this.src = src;
        }

        @Override
        public KtToken nextToken(KtBoolPar canExpand) {
            if (this.pos < KtMacro.this.body.length()) {
                KtToken tok;
                if ((tok = KtMacro.this.body.tokenAt(this.pos++)).isMacroParameter()) {
                    KtTokenList param = this.params[tok.macroParameterNumber()];
                    KtCommandBase.pushList(param, "argument");
                    return this.getStack().nextToken(canExpand);
                }
                canExpand.set(true);
                return tok;
            }
            canExpand.set(false);
            return KtToken.NULL;
        }

        @Override
        public boolean finishedList() {
            return this.pos >= KtMacro.this.body.length();
        }

        @Override
        public int show(KtContextDisplay disp, boolean force, int lines) {
            this.src.addProperlyOn(disp.normal().endLine());
            KtLog left = disp.left();
            int count = left.getCount();
            KtMacro.this.body.addContext(left, disp.right(), this.pos, count += 100000 - KtMacro.this.addMask(left).getCount());
            disp.show();
            return 1;
        }
    }

    private static class KtMatchChecker
    extends KtScanToksChecker {
        private final KtBytePar parReact;

        public KtMatchChecker(KtTokenList.KtBuffer buf, KtLoggable src, KtBytePar pr) {
            super("OuterInMatch", "EOFinMatch", "argument", buf, src, PAR_TOKEN);
            this.parReact = pr;
        }

        @Override
        protected void reportError(String ident) {
            this.parReact.set((byte)1);
            super.reportError(ident);
        }
    }

    private static class KtParAbort
    extends Exception {
        public KtToken tok;

        public KtParAbort(KtToken tok) {
            this.tok = tok;
        }
    }
}

