/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.hyph;

import com.whitemagicsoftware.keentype.node.KtHyphens;

public class KtArrayHyphens
implements KtHyphens {
    public static final KtArrayHyphens EMPTY = new KtArrayHyphens(new boolean[0]);
    private final boolean[] array;

    public KtArrayHyphens(boolean[] array) {
        this.array = array;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public boolean hyphenAt(int pos) {
        return pos < this.array.length && this.array[pos];
    }

    @Override
    public String toString(String word) {
        StringBuilder buf = new StringBuilder(2 * word.length() + 1);
        for (int i = 0; i < word.length(); ++i) {
            if (this.hyphenAt(i)) {
                buf.append('-');
            }
            buf.append(word.charAt(i));
        }
        if (this.hyphenAt(word.length())) {
            buf.append('-');
        }
        return buf.toString();
    }

    public static KtArrayHyphens forPositions(int[] positions, int start, int end) {
        if (start <= end) {
            int i;
            for (i = 0; i < positions.length && positions[i] < start; ++i) {
            }
            int l = positions.length;
            while (--l > 0 && positions[l] > end) {
            }
            if (i <= l) {
                boolean[] array = new boolean[positions[l] + 1];
                while (i <= l) {
                    array[positions[i++]] = true;
                }
                return new KtArrayHyphens(array);
            }
        }
        return EMPTY;
    }
}

