/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.hyph;

import com.whitemagicsoftware.keentype.hyph.KtArrayHyphens;
import com.whitemagicsoftware.keentype.hyph.KtHashHyphenation;
import com.whitemagicsoftware.keentype.hyph.KtHyphNode;
import com.whitemagicsoftware.keentype.hyph.KtWordMap;
import com.whitemagicsoftware.keentype.node.KtHyphens;
import com.whitemagicsoftware.keentype.node.KtLanguage;
import java.util.Map;

public class KtHyphLanguage
extends KtLanguage {
    private final KtHashHyphenation hashHyph;
    private final KtWordMap patterns;
    private final Map<KtHyphNode, KtHyphNode> nodeMap;
    private final int[] nodeStats;

    public KtHyphLanguage(int ln, int lhm, int rhm, KtHashHyphenation hashHyph, KtWordMap patterns, Map<KtHyphNode, KtHyphNode> nodeMap, int[] nodeStats) {
        super(ln, lhm, rhm);
        this.hashHyph = hashHyph;
        this.patterns = patterns;
        this.nodeMap = nodeMap;
        this.nodeStats = nodeStats;
    }

    @Override
    public KtHyphens getHyphens(String word) {
        int size = word.length();
        if (size >= this.leftHyphenMin + this.rightHyphenMin) {
            int k;
            int i;
            int[] hyphens = this.hashHyph.getPositions(word);
            if (hyphens != null) {
                return KtArrayHyphens.forPositions(hyphens, this.leftHyphenMin, size - this.rightHyphenMin);
            }
            char[] codes = new char[size + 2];
            word.getChars(0, size, codes, 1);
            codes[size + 1] = '\u0000';
            codes[0] = '\u0000';
            int[] values = new int[size + 3];
            KtWordMap.KtSeeker seeker = this.patterns.seeker();
            int right = size - this.rightHyphenMin + 2;
            for (i = 0; i < right; ++i) {
                for (int l = i; l < codes.length; ++l) {
                    seeker.seek(codes[l]);
                    if (!seeker.isValid()) break;
                    KtHyphNode hyph = (KtHyphNode)seeker.get();
                    int k2 = i;
                    while (hyph != KtHyphNode.NULL) {
                        if (values[k2 += hyph.offset] < hyph.value) {
                            values[k2] = hyph.value;
                        }
                        hyph = hyph.next;
                        ++k2;
                    }
                }
                seeker.reset();
            }
            for (i = 1; i <= this.leftHyphenMin; ++i) {
                values[i] = 0;
            }
            for (k = size - this.rightHyphenMin + 1; k > 0 && (values[k] & 1) == 0; --k) {
            }
            if (k > 0) {
                boolean[] array = new boolean[k];
                do {
                    boolean bl = array[k] = (values[--k + 1] & 1) != 0;
                } while (k > 0);
                return new KtArrayHyphens(array);
            }
        }
        return KtArrayHyphens.EMPTY;
    }

    @Override
    public void setHyphException(String word, int[] positions) {
        this.hashHyph.setPositions(word, positions);
    }

    @Override
    public boolean setHyphPattern(String patt, int[] values) {
        KtHyphNode hyph = this.makeHyphNodes(values);
        KtHyphNode old = (KtHyphNode)this.patterns.put(patt, hyph);
        return old == KtHyphNode.NULL || old.isZero();
    }

    private KtHyphNode makeHyphNodes(int[] values) {
        KtHyphNode hyph = KtHyphNode.NULL;
        int n = values.length;
        while (--n >= 0 && values[n] == 0) {
        }
        if (n < 0) {
            return KtHyphNode.ZERO;
        }
        while (n >= 0) {
            int i = n;
            while (--i >= 0 && values[i] == 0) {
            }
            KtHyphNode hashed = this.nodeMap.get(hyph = new KtHyphNode(n - i - 1, values[n], hyph));
            if (hashed == KtHyphNode.NULL) {
                this.nodeMap.put(hyph, hyph);
            } else {
                hyph = hashed;
                this.nodeStats[1] = this.nodeStats[1] + 1;
            }
            n = i;
            this.nodeStats[0] = this.nodeStats[0] + 1;
        }
        return hyph;
    }

    public static String toString(String patt, KtHyphNode hyph) {
        int i;
        StringBuilder buf = new StringBuilder(2 * patt.length());
        int h = hyph != KtHyphNode.NULL ? hyph.offset : -1;
        for (i = 0; i < patt.length(); ++i) {
            char code = patt.charAt(i);
            if (code == '\u0000') {
                code = '.';
            }
            if (i == h) {
                if (hyph.value != 0) {
                    buf.append(hyph.value);
                }
                h = (hyph = hyph.next) != KtHyphNode.NULL ? h + hyph.offset + 1 : -1;
            } else if (Character.isDigit(code)) {
                buf.append('0');
            }
            buf.append(code);
        }
        if (i == h && hyph.value != 0) {
            buf.append(hyph.value);
        }
        return buf.toString();
    }
}

