/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.noad;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.noad.KtConverter;
import com.whitemagicsoftware.keentype.noad.KtEgg;
import com.whitemagicsoftware.keentype.noad.KtField;
import com.whitemagicsoftware.keentype.noad.KtNoad;
import com.whitemagicsoftware.keentype.noad.KtOperator;
import com.whitemagicsoftware.keentype.noad.KtStSimpleNodeEgg;
import com.whitemagicsoftware.keentype.noad.KtWordPartNoad;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtGlueSetting;
import com.whitemagicsoftware.keentype.node.KtIntVKernNode;
import com.whitemagicsoftware.keentype.node.KtMathWordBuilder;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtVBoxNode;
import com.whitemagicsoftware.keentype.node.KtVShiftNode;

public class KtOpNoad
extends KtWordPartNoad {
    public static final byte SIDE_LIMITS = 0;
    public static final byte USUAL_LIMITS = 1;
    public static final byte DEFAULT_LIMITS = 2;
    private final byte limits;

    public KtOpNoad(KtField nucleus, byte limits) {
        super(nucleus);
        this.limits = limits;
    }

    public KtOpNoad(KtField nucleus) {
        super(nucleus);
        this.limits = (byte)2;
    }

    @Override
    protected String getDesc() {
        return "mathop";
    }

    @Override
    public boolean acceptsLimits() {
        return true;
    }

    @Override
    public boolean canPrecedeBin() {
        return false;
    }

    @Override
    protected byte spacingType() {
        return 1;
    }

    @Override
    public KtNoad withLimits(byte limits) {
        return new KtOpNoad(this.nucleus, limits);
    }

    @Override
    public void addOn(KtLog log, KtCntxLog cntx) {
        log.addEsc(this.getDesc());
        switch (this.limits) {
            case 0: {
                log.addEsc("nolimits");
                break;
            }
            case 1: {
                log.addEsc("limits");
            }
        }
        this.nucleus.addOn(log, cntx, '.');
    }

    protected boolean usingLimits(KtConverter conv, boolean display) {
        return switch (this.limits) {
            case 0 -> false;
            case 1 -> true;
            default -> display;
        };
    }

    @Override
    public boolean isJustChar() {
        return false;
    }

    @Override
    public KtEgg convert(KtConverter conv) {
        boolean display = conv.getStyle() == 0;
        return this.makeEgg(this.nucleus.makeOperator(conv, display), conv, display);
    }

    @Override
    public KtEgg wordFinishingEgg(KtMathWordBuilder word, KtConverter conv) {
        if (word.lastHasCollapsed()) {
            return KtEgg.NULL;
        }
        boolean display = conv.getStyle() == 0;
        return this.makeEgg(this.nucleus.takeLastOperator(word, conv, display), conv, display);
    }

    private KtEgg makeEgg(KtOperator oper, KtConverter conv, boolean display) {
        return this.usingLimits(conv, display) ? new KtStSimpleNodeEgg(KtVBoxNode.packedOf(oper.getNodeToBeLimited()), this.spacingType()) : oper.getEggToBeScripted(this.spacingType());
    }

    @Override
    public KtEgg convertWithScripts(KtConverter conv, KtField sup, KtField sub) {
        boolean display;
        boolean bl = display = conv.getStyle() == 0;
        if (!this.usingLimits(conv, display)) {
            return super.convertWithScripts(conv, sup, sub);
        }
        return this.makeEggWithScripts(this.nucleus.makeOperator(conv, display), conv, sup, sub);
    }

    @Override
    public KtEgg wordFinishingEggWithScripts(KtMathWordBuilder word, KtConverter conv, KtField sup, KtField sub) {
        boolean display;
        boolean bl = display = conv.getStyle() == 0;
        if (word.lastHasCollapsed() || !this.usingLimits(conv, display)) {
            return super.wordFinishingEggWithScripts(word, conv, sup, sub);
        }
        return this.makeEggWithScripts(this.nucleus.takeLastOperator(word, conv, display), conv, sup, sub);
    }

    private KtEgg makeEggWithScripts(KtOperator oper, KtConverter conv, KtField sup, KtField sub) {
        KtDimen clr;
        KtNode body = oper.getNodeToBeLimited();
        KtDimen width = body.getWidth();
        KtNode supNode = KtNode.NULL;
        KtNode subNode = KtNode.NULL;
        if (!sup.isEmpty()) {
            supNode = sup.cleanBox(conv, (byte)3);
            width = width.max(supNode.getWidth());
        }
        if (!sub.isEmpty()) {
            subNode = sub.cleanBox(conv, (byte)2);
            width = width.max(subNode.getWidth());
        }
        body = body.reboxedToWidth(width);
        KtDimen height = body.getHeight();
        KtDimen depth = body.getDepth();
        KtDimen leftX = body.getLeftX();
        KtNodeList list = new KtNodeList();
        KtDimen extra = conv.getDimPar(22);
        KtDimen delta = oper.getItalCorr();
        if (delta != KtDimen.NULL) {
            delta = delta.halved();
        }
        if (supNode != KtNode.NULL) {
            supNode = supNode.reboxedToWidth(width);
            leftX = leftX.max(supNode.getLeftX());
            clr = conv.getDimPar(20).minus(supNode.getDepth());
            clr = clr.max(conv.getDimPar(18));
            height = height.plus(extra).plus(supNode.getHeight()).plus(supNode.getDepth()).plus(clr);
            list.append(new KtIntVKernNode(extra));
            list.append(delta == KtDimen.NULL ? supNode : KtVShiftNode.shiftingRight(supNode, delta));
            list.append(new KtIntVKernNode(clr));
        }
        list.append(body);
        if (subNode != KtNode.NULL) {
            subNode = subNode.reboxedToWidth(width);
            leftX = leftX.max(subNode.getLeftX());
            clr = conv.getDimPar(21).minus(subNode.getHeight());
            clr = clr.max(conv.getDimPar(19));
            depth = depth.plus(extra).plus(subNode.getHeight()).plus(subNode.getDepth()).plus(clr);
            list.append(new KtIntVKernNode(clr));
            list.append(delta == KtDimen.NULL ? subNode : KtVShiftNode.shiftingLeft(subNode, delta));
            list.append(new KtIntVKernNode(extra));
        }
        return new KtStSimpleNodeEgg(new KtVBoxNode(new KtBoxSizes(height, width, depth, leftX), KtGlueSetting.NATURAL, list), this.spacingType());
    }
}

