/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;

public class KtSizesSummarizer {
    private KtDimen height;
    private KtDimen body;
    private KtDimen depth;
    private KtDimen width;
    private KtDimen leftX;
    private final KtDimen[] totalStr = new KtDimen[4];
    private final KtDimen[] totalShr = new KtDimen[4];

    public final KtDimen getHeight() {
        return this.height;
    }

    public final KtDimen getBody() {
        return this.body;
    }

    public final KtDimen getDepth() {
        return this.depth;
    }

    public final KtDimen getWidth() {
        return this.width;
    }

    public final KtDimen getLeftX() {
        return this.leftX;
    }

    public final KtDimen getTotalStr(byte ord) {
        return this.totalStr[ord];
    }

    public final KtDimen getTotalShr(byte ord) {
        return this.totalShr[ord];
    }

    public final byte maxTotalStr() {
        return this.maxOrd(this.totalStr);
    }

    public final byte maxTotalShr() {
        return this.maxOrd(this.totalShr);
    }

    public KtSizesSummarizer() {
        this.height = KtDimen.ZERO;
        this.body = KtDimen.ZERO;
        this.depth = KtDimen.ZERO;
        this.width = KtDimen.ZERO;
        this.leftX = KtDimen.ZERO;
        this.setZero(this.totalStr);
        this.setZero(this.totalShr);
    }

    public final void add(KtDimen dim) {
        this.body = this.body.plus(dim);
    }

    public final void setHeight(KtDimen h) {
        this.add(this.height);
        this.height = h;
    }

    public final void setDepth(KtDimen d) {
        this.add(this.depth);
        this.depth = d;
    }

    public final void setMaxWidth(KtDimen w) {
        this.width = this.width.max(w);
    }

    public final void setMaxLeftX(KtDimen l) {
        this.leftX = this.leftX.max(l);
    }

    public final void addStretch(KtDimen dim, byte ord) {
        this.addOrd(this.totalStr, dim, ord);
    }

    public final void addShrink(KtDimen dim, byte ord) {
        this.addOrd(this.totalShr, dim, ord);
    }

    public final void add(KtGlue glue) {
        this.body = this.body.plus(glue.getDimen());
        this.addStretch(glue.getStretch(), glue.getStrOrder());
        this.addShrink(glue.getShrink(), glue.getShrOrder());
    }

    public final void restrictDepth(KtDimen maxDepth) {
        if (this.depth.moreThan(maxDepth)) {
            this.body = this.body.plus(this.depth).minus(maxDepth);
            this.depth = maxDepth;
        }
    }

    private void setZero(KtDimen[] total) {
        int i = total.length;
        while (i-- > 0) {
            total[i] = KtDimen.ZERO;
        }
    }

    private void addOrd(KtDimen[] total, KtDimen dim, byte ord) {
        if (!dim.isZero()) {
            total[ord] = total[ord].plus(dim);
        }
    }

    private byte maxOrd(KtDimen[] total) {
        byte ord;
        for (ord = 3; ord > 0 && total[ord].isZero(); ord = (byte)(ord - 1)) {
        }
        return ord;
    }
}

