/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.render;

import com.whitemagicsoftware.keentype.tex.KtFontInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class KtCodePointMapper {
    private static final Function<Integer, Integer> CODEPOINT = codepoint -> codepoint;
    private static final Function<Integer, Integer> CM = codepoint -> {
        if (codepoint <= 9) {
            return codepoint + 161;
        }
        if (codepoint == 20) {
            return 128;
        }
        if (codepoint <= 32) {
            return codepoint + 163;
        }
        return codepoint;
    };
    private static final Map<String, Function<Integer, Integer>> CODEPOINTS = new HashMap<String, Function<Integer, Integer>>(256);
    private Function<Integer, Integer> mCodePoint = CODEPOINT;

    public void font(KtFontInfo info) {
        String fontName = new String(info.getFileName());
        this.mCodePoint = CODEPOINTS.getOrDefault(fontName, CODEPOINT);
    }

    public int lookup(int codepoint) {
        return this.mCodePoint.apply(codepoint);
    }

    static {
        CODEPOINTS.put("cmmi5", CM);
        CODEPOINTS.put("cmmi6", CM);
        CODEPOINTS.put("cmmi7", CM);
        CODEPOINTS.put("cmmi8", CM);
        CODEPOINTS.put("cmmi9", CM);
        CODEPOINTS.put("cmmi10", CM);
        CODEPOINTS.put("cmmi11", CM);
        CODEPOINTS.put("cmmi12", CM);
        CODEPOINTS.put("cmmib6", CM);
        CODEPOINTS.put("cmmib7", CM);
        CODEPOINTS.put("cmmib8", CM);
        CODEPOINTS.put("cmmib9", CM);
        CODEPOINTS.put("cmmib10", CM);
        CODEPOINTS.put("cmsy5", CM);
        CODEPOINTS.put("cmsy6", CM);
        CODEPOINTS.put("cmsy7", CM);
        CODEPOINTS.put("cmsy8", CM);
        CODEPOINTS.put("cmsy9", CM);
        CODEPOINTS.put("cmsy10", CM);
        CODEPOINTS.put("cmbsy6", CM);
        CODEPOINTS.put("cmbsy7", CM);
        CODEPOINTS.put("cmbsy8", CM);
        CODEPOINTS.put("cmbsy9", CM);
        CODEPOINTS.put("cmbsy10", CM);
        CODEPOINTS.put("cmex7", CM);
        CODEPOINTS.put("cmex8", CM);
        CODEPOINTS.put("cmex9", CM);
        CODEPOINTS.put("cmex10", CM);
        CODEPOINTS.put("cmbx5", CM);
        CODEPOINTS.put("cmbx6", CM);
        CODEPOINTS.put("cmbx7", CM);
        CODEPOINTS.put("cmbx8", CM);
        CODEPOINTS.put("cmbx9", CM);
        CODEPOINTS.put("cmbx10", CM);
        CODEPOINTS.put("cmbx12", CM);
        CODEPOINTS.put("cmr5", CM);
        CODEPOINTS.put("cmr6", CM);
        CODEPOINTS.put("cmr7", CM);
        CODEPOINTS.put("cmr8", CM);
        CODEPOINTS.put("cmr9", CM);
        CODEPOINTS.put("cmr10", CM);
        CODEPOINTS.put("cmr12", CM);
        CODEPOINTS.put("cmr17", CM);
        CODEPOINTS.put("cmb10", CM);
        CODEPOINTS.put("cmtt8", CM);
        CODEPOINTS.put("cmtt9", CM);
        CODEPOINTS.put("cmtt10", CM);
        CODEPOINTS.put("cmtt12", CM);
        CODEPOINTS.put("cmsltt10", CM);
        CODEPOINTS.put("cmsl8", CM);
        CODEPOINTS.put("cmsl9", CM);
        CODEPOINTS.put("cmsl10", CM);
        CODEPOINTS.put("cmsl12", CM);
        CODEPOINTS.put("cmu10", CM);
        CODEPOINTS.put("cmti7", CM);
        CODEPOINTS.put("cmti8", CM);
        CODEPOINTS.put("cmti9", CM);
        CODEPOINTS.put("cmti10", CM);
        CODEPOINTS.put("cmti12", CM);
        CODEPOINTS.put("cmxsl10", CM);
        CODEPOINTS.put("cmxti10", CM);
        CODEPOINTS.put("cmbxsl10", CM);
        CODEPOINTS.put("cmbxti10", CM);
        CODEPOINTS.put("cmtex8", CM);
        CODEPOINTS.put("cmtex9", CM);
        CODEPOINTS.put("cmtex10", CM);
        CODEPOINTS.put("cmdunh10", CM);
        CODEPOINTS.put("cmsc8", CM);
        CODEPOINTS.put("cmsc9", CM);
        CODEPOINTS.put("cmsc10", CM);
        CODEPOINTS.put("cmcsc10", CM);
        CODEPOINTS.put("cmcsc8", CM);
        CODEPOINTS.put("cmcsc9", CM);
        CODEPOINTS.put("cmtcsc10", CM);
        CODEPOINTS.put("cmff10", CM);
        CODEPOINTS.put("cmfi10", CM);
        CODEPOINTS.put("cmfib8", CM);
        CODEPOINTS.put("cminch", CM);
        CODEPOINTS.put("cmitt10", CM);
        CODEPOINTS.put("cmss10", CM);
        CODEPOINTS.put("cmss12", CM);
        CODEPOINTS.put("cmss17", CM);
        CODEPOINTS.put("cmss8", CM);
        CODEPOINTS.put("cmss9", CM);
        CODEPOINTS.put("cmssbx10", CM);
        CODEPOINTS.put("cmssdc10", CM);
        CODEPOINTS.put("cmssi8", CM);
        CODEPOINTS.put("cmssi9", CM);
        CODEPOINTS.put("cmssi10", CM);
        CODEPOINTS.put("cmssi12", CM);
        CODEPOINTS.put("cmssi17", CM);
        CODEPOINTS.put("cmssq8", CM);
        CODEPOINTS.put("cmssqi8", CM);
        CODEPOINTS.put("cmvtt10", CM);
    }
}

