/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tex;

import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtContextDisplay;
import com.whitemagicsoftware.keentype.command.KtFileName;
import com.whitemagicsoftware.keentype.command.KtInputLineTokenizer;
import com.whitemagicsoftware.keentype.command.KtInteractionPrim;
import com.whitemagicsoftware.keentype.command.KtLineInputReadInput;
import com.whitemagicsoftware.keentype.command.KtLineInputTokenizer;
import com.whitemagicsoftware.keentype.command.KtReadInput;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.command.KtTokenizer;
import com.whitemagicsoftware.keentype.events.KtCloseLogEvent;
import com.whitemagicsoftware.keentype.events.KtErrorEvent;
import com.whitemagicsoftware.keentype.events.KtOpenLogEvent;
import com.whitemagicsoftware.keentype.events.KtResetErrorCountEvent;
import com.whitemagicsoftware.keentype.events.KtTypesettingBeganEvent;
import com.whitemagicsoftware.keentype.events.KtTypesettingEndedEvent;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtInputLine;
import com.whitemagicsoftware.keentype.io.KtLineInput;
import com.whitemagicsoftware.keentype.io.KtLineOutput;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.io.KtName;
import com.whitemagicsoftware.keentype.io.KtStandardLog;
import com.whitemagicsoftware.keentype.io.KtStringLog;
import com.whitemagicsoftware.keentype.io.KtWriterLineOutput;
import com.whitemagicsoftware.keentype.node.KtTypesetter;
import com.whitemagicsoftware.keentype.tex.KtConfig;
import com.whitemagicsoftware.keentype.tex.KtFatalError;
import com.whitemagicsoftware.keentype.tex.KtFileFormat;
import com.whitemagicsoftware.keentype.tex.KtFileOpener;
import com.whitemagicsoftware.keentype.tex.KtTeXCharMapper;
import com.whitemagicsoftware.keentype.tex.KtTeXContextDisplay;
import com.whitemagicsoftware.keentype.tex.KtTeXError;
import com.whitemagicsoftware.keentype.tex.KtTeXErrorPool;
import com.whitemagicsoftware.keentype.tex.KtTeXTokenMaker;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class KtTeXIOHandler
implements KtCommandBase.KtIOHandler,
KtLineInputTokenizer.KtInputHandler,
KtLineInputReadInput.KtInputHandler,
KtTeXTokenMaker.KtErrHandler {
    private final KtConfig mConfig;
    private final KtTeXCharMapper mMapper;
    private final KtTeXTokenMaker mMaker;
    private final KtContextDisplay mContextDisplay;
    private final KtTypesetter mTypesetter;
    private KtName jobName = KtName.NULL;
    private boolean afterEnd;
    private transient String shownBuilderName = null;
    private ObjectOutputStream dumper = null;

    public KtTeXIOHandler(KtConfig config, KtTeXCharMapper mapper, KtTeXTokenMaker maker, KtTeXContextDisplay display, KtTypesetter typeSetter) {
        assert (config != null);
        assert (mapper != null);
        assert (display != null);
        assert (typeSetter != null);
        this.mConfig = config;
        this.mMapper = mapper;
        this.mTypesetter = typeSetter;
        this.mMaker = maker;
        this.mContextDisplay = display;
    }

    public KtTeXTokenMaker getTokenMaker() {
        return this.mMaker;
    }

    @Override
    public KtName getJobName() {
        if (this.jobName == KtName.NULL) {
            this.jobName = KtToken.makeName("texput");
            this.openLogFile(this.jobName);
        }
        return this.jobName;
    }

    @Override
    public void ensureOpenLog() {
        this.getJobName();
    }

    @Override
    public void openInput(KtFileName name) {
        Reader in;
        KtFileName fullName;
        while (true) {
            fullName = name.copy();
            try {
                in = this.openReader(fullName, KtFileFormat.INPUT_EXT);
            }
            catch (IOException e) {
                this.cantOpen(name, true);
                name = this.promptFileName("input file name");
                continue;
            }
            break;
        }
        if (this.jobName == KtName.NULL) {
            this.jobName = name.baseName();
            this.openLogFile(this.jobName);
        }
        int len = KtCommand.normLog.voidCounter().add(fullName).getCount();
        KtCommand.normLog.sepRoom(len + 2).add('(').add(fullName).flush();
        KtCommand.getTokStack().push(new KtLineInputTokenizer(new KtLineInput(in, (KtInputLine.KtMapper)this.mMapper), this, name));
    }

    public void setAfterEnd() {
        this.afterEnd = true;
    }

    @Override
    public void closeInput() {
        if (this.afterEnd) {
            KtCommand.normLog.add(' ');
        }
        KtCommand.normLog.add(')').flush();
    }

    @Override
    public KtReadInput openRead(KtFileName name, int num) {
        Reader in;
        try {
            in = this.openReader(name, KtFileFormat.READ_EXT);
        }
        catch (IOException e) {
            return KtReadInput.NULL;
        }
        return new KtLineInputReadInput(new KtLineInput(in, (KtInputLine.KtMapper)this.mMapper), this, num);
    }

    @Override
    public KtReadInput defaultRead(int num) {
        return new KtStdinReadInput(this, num);
    }

    @Override
    public KtLog openWrite(KtFileName name, int num) {
        Writer wr;
        while (true) {
            try {
                wr = KtTeXIOHandler.openWriter(name, KtFileFormat.WRITE_EXT);
            }
            catch (IOException e) {
                this.cantOpen(name, false);
                name = this.promptFileName("output file name");
                continue;
            }
            break;
        }
        if (this.jobName != KtName.NULL) {
            KtCommand.diagLog.startLine().addEsc("openout").add(num).add(" = `").add(name).add("'.").startLine().endLine();
        }
        return new KtStandardLog(new KtWriterLineOutput(wr, this.mMapper), this.mMapper);
    }

    @Override
    public KtLog makeLog(KtLineOutput out) {
        return new KtStandardLog(out, this.mMapper);
    }

    @Override
    public KtLog makeStringLog() {
        return new KtStringLog(this.mMapper);
    }

    @Override
    public KtFileName makeFileName() {
        return new KtTeXCharMapper.KtTeXFileName();
    }

    @Override
    public void error(String ident, KtLoggable[] params, boolean delAllowed) {
        this.error(KtTeXErrorPool.get(ident), params, true, delAllowed);
    }

    @Override
    public void fatalError(String ident) {
        this.ensureOpenLog();
        KtInteractionPrim.setScroll();
        KtTeXError err = KtTeXErrorPool.get(ident);
        if (KtCommand.isFileLogActive()) {
            this.error(err, null, true, false);
        } else {
            err.addText(KtCommand.normLog.startLine().add("! "), null);
        }
        throw new KtFatalError(ident);
    }

    @Override
    public void errMessage(KtTokenList message) {
        this.error(KtTeXErrorPool.get(message, this.mConfig.errHelp()), null, true, true);
    }

    @Override
    public void logMode() {
        String name = KtTypoCommand.getBld().modeName();
        if (!name.equals(this.shownBuilderName)) {
            KtCommand.diagLog.add(KtTypoCommand.getBld()).add(": ");
            this.shownBuilderName = name;
        }
    }

    @Override
    public void completeShow() {
        String ident = !KtInteractionPrim.isErrStopping() ? "Void" : (KtCommand.termDiagActive() ? "ShortShow" : "LongShow");
        this.error(KtTeXErrorPool.get(ident), null, false, true);
    }

    @Override
    public void illegalCommand(KtCommand cmd) {
        KtTypoCommand.illegalCase(cmd, KtTypoCommand.getBld());
    }

    @Override
    public void resetErrorCount() {
        KtResetErrorCountEvent.publish();
    }

    private void error(KtTeXError err, KtLoggable[] params, boolean counting, boolean delAllowed) {
        KtErrorEvent.publish(err, params, counting, delAllowed);
    }

    private KtFileName getFileName() {
        return new KtTeXCharMapper.KtTeXFileName(this.getJobName());
    }

    public void setScale(double scale) {
        this.mTypesetter.setScale(scale);
    }

    public void startDocument() {
        KtTypesettingBeganEvent.publish();
        this.mTypesetter.startDocument(this.getFileName());
    }

    public void startDocument(OutputStream out) {
        KtTypesettingBeganEvent.publish();
        this.mTypesetter.startDocument(out);
    }

    public void stopDocument() {
        this.mTypesetter.close();
        KtTypesettingEndedEvent.publish(this.mTypesetter);
    }

    public ObjectOutputStream getDumper() throws IOException {
        if (this.dumper == null) {
            KtTeXCharMapper.KtTeXFileName name = new KtTeXCharMapper.KtTeXFileName(this.getJobName());
            BufferedOutputStream out = new BufferedOutputStream(KtFileOpener.write(name, KtFileFormat.FMT_EXT));
            this.dumper = new ObjectOutputStream(out);
        }
        return this.dumper;
    }

    public void closeLogFile() {
        KtCloseLogEvent.publish();
    }

    private void openLogFile(KtName jobName) {
        KtOpenLogEvent.publish(jobName);
    }

    private KtFileName promptFileName(String prompt) {
        KtCharCode code;
        KtCommand.normLog.startLine().add("Please type another ").add(prompt);
        if (!KtInteractionPrim.isInteractive()) {
            this.fatalError("MissingFile");
        }
        KtInputLine line = KtCommand.promptInput(": ");
        KtTeXCharMapper.KtTeXFileName name = new KtTeXCharMapper.KtTeXFileName();
        line.skipSpaces();
        while ((code = line.getNextRawCode()) != KtInputLine.EOL && name.accept(code) > 0) {
        }
        return name;
    }

    private void cantOpen(KtFileName name, boolean inp) {
        KtCommand.normLog.startLine().add(inp ? "! I can't find file `" : "! I can't write on file `").add(name).add("'.");
        KtCommand.getTokStack().show(this.mContextDisplay);
    }

    @Override
    public KtInputLine emptyLine() {
        return new KtInputLine(this.mMapper);
    }

    @Override
    public KtInputLine confirmLine(KtInputLine line) {
        if (this.mConfig.confirmingLines() && KtInteractionPrim.isInteractive()) {
            KtCommand.normLog.endLine().add(line);
            KtInputLine instead = KtCommand.promptInput("=>");
            if (instead != KtInputLine.NULL && !instead.empty()) {
                return instead;
            }
        }
        return line;
    }

    @Override
    public KtTokenizer makeTokenizer(KtInputLine line, String desc, boolean addEolc) {
        if (addEolc) {
            line = line.addEndOfLineChar();
        }
        return new KtInputLineTokenizer(line, this.mMaker, desc);
    }

    public static Reader makeReader(InputStream in) {
        return new InputStreamReader(in, StandardCharsets.UTF_8);
    }

    private Reader openReader(KtFileName name, KtFileFormat format) throws IOException {
        return KtTeXIOHandler.makeReader(new BufferedInputStream(KtFileOpener.readFile(name, format)));
    }

    public static Writer makeWriter(OutputStream out) {
        return new OutputStreamWriter(out, StandardCharsets.UTF_8);
    }

    public static Writer openWriter(KtFileName name, KtFileFormat format) throws IOException {
        return KtTeXIOHandler.makeWriter(new BufferedOutputStream(KtFileOpener.write(name, format)));
    }

    public static InputStream openTeXFm(KtFileName name) throws IOException {
        return new BufferedInputStream(KtFileOpener.readFile(name, KtFileFormat.TFM_EXT));
    }

    static class KtStdinReadInput
    implements KtReadInput {
        private final KtTeXIOHandler handler;
        private final int num;
        private final String desc = "<read *> ";

        public KtStdinReadInput(KtTeXIOHandler handler, int num) {
            this.handler = handler;
            this.num = num;
        }

        @Override
        public KtTokenizer nextTokenizer(KtToken def, int ln) {
            KtInputLine line;
            if (!KtInteractionPrim.isInteractive()) {
                KtCommand.fatalError("NoTermRead");
            }
            if (this.num > 0 && ln == 0) {
                KtCommand.normLog.endLine().add(def);
                line = KtCommand.promptInput("=");
            } else {
                line = KtCommand.promptInput("");
            }
            return line == KtLineInput.EOF ? KtTokenizer.NULL : this.handler.makeTokenizer(line, "<read *> ", true);
        }

        @Override
        public KtTokenizer emptyLineTokenizer() {
            return this.handler.makeTokenizer(this.handler.emptyLine(), "<read *> ", true);
        }

        @Override
        public void close() {
        }
    }
}

