/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.command.KtBaseToksChecker;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtInpTokChecker;
import com.whitemagicsoftware.keentype.command.KtMacro;
import com.whitemagicsoftware.keentype.command.KtMacroBody;
import com.whitemagicsoftware.keentype.command.KtMacroParamToken;
import com.whitemagicsoftware.keentype.command.KtPrefixPrim;
import com.whitemagicsoftware.keentype.command.KtRightBraceToken;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtMaxLoggable;

public class KtDefPrim
extends KtPrefixPrim {
    private final boolean xpand;
    private final int prefix;

    public KtDefPrim(String name, boolean xpand, int prefix) {
        super(name);
        this.xpand = xpand;
        this.prefix = prefix;
    }

    @Override
    public void exec(KtToken src, int prefixes) {
        KtToken tok = KtDefPrim.definableToken();
        KtMacroDefining def = new KtMacroDefining(tok);
        this.scanDef(tok, def);
        KtMacro mac = def.toMacro((prefixes |= this.prefix) & 3);
        tok.define(mac, KtDefPrim.globalAssignment(prefixes));
        KtDefPrim.afterAssignment();
    }

    public void scanDef(KtToken defMac, KtMacroDefining def) {
        KtToken hashBrace = KtToken.NULL;
        boolean valid = true;
        KtInpTokChecker savedChk = KtDefPrim.setTokenChecker(def);
        while (true) {
            KtToken tok;
            KtCommand cmd;
            if ((cmd = KtDefPrim.meaningOf(tok = KtDefPrim.nextRawToken())).isMacroParam()) {
                def.matchCode = cmd.charCode();
                tok = KtDefPrim.nextRawToken();
                if (KtDefPrim.meaningOf(tok).isLeftBrace()) {
                    hashBrace = tok;
                    def.addToMask(tok);
                    break;
                }
                if (def.paramCnt() < 9) {
                    if (!tok.matchOther(Character.forDigit(def.paramCnt() + 1, 10))) {
                        KtDefPrim.backToken(tok);
                        KtDefPrim.error("NonConseqParams");
                    }
                    def.addParam();
                    continue;
                }
                KtDefPrim.error("TooManyParams");
            } else {
                if (tok.matchLeftBrace()) break;
                if (tok.matchRightBrace()) {
                    KtDefPrim.adjustBraceNesting(1);
                    valid = false;
                    KtDefPrim.error("MissingLeftDefBrace");
                    break;
                }
            }
            def.addToMask(tok);
        }
        def.bodyBuf = new KtMacroBody.KtBuffer(30);
        if (valid) {
            this.scanBody(defMac, def);
        }
        if (hashBrace != KtToken.NULL) {
            def.bodyBuf.append(hashBrace);
        }
        KtDefPrim.setTokenChecker(savedChk);
    }

    private void scanBody(KtToken defMac, KtMacroDefining def) {
        KtMacroBody.KtBuffer buf = def.bodyBuf;
        int balance = 1;
        while (true) {
            KtToken tok;
            if ((tok = KtDefPrim.nextScannedToken(this.xpand, buf)) == KtToken.NULL) {
                continue;
            }
            if (KtDefPrim.meaningOf(tok).isMacroParam()) {
                KtToken prevTok = tok;
                KtToken ktToken = tok = this.xpand ? KtDefPrim.nextExpToken() : KtDefPrim.nextRawToken();
                if (!KtDefPrim.meaningOf(tok).isMacroParam()) {
                    int digit;
                    char dig = tok.otherChar();
                    if (dig != '\uffff' && dig >= '1' && (digit = dig - 49) < def.paramCnt()) {
                        buf.appendParam(digit, def.matchCode);
                        continue;
                    }
                    KtDefPrim.backToken(tok);
                    tok = prevTok;
                    KtDefPrim.error("IllegalParamNum", defMac);
                }
            } else if (tok.matchLeftBrace()) {
                ++balance;
            } else if (tok.matchRightBrace() && --balance == 0) break;
            buf.append(tok);
        }
    }

    static class KtMacroDefining
    extends KtBaseToksChecker
    implements KtMaxLoggable {
        public KtCharCode matchCode = KtMacroParamToken.CODE;
        public KtMacroBody.KtBuffer bodyBuf = null;
        private final KtCharCode[] matchCodes = new KtCharCode[9];
        private final KtTokenList[] paramMask = new KtTokenList[10];
        private KtTokenList.KtBuffer paramBuf = new KtTokenList.KtBuffer(10, 10);
        private int count = 0;

        public KtMacroDefining(KtToken source) {
            super("OuterInDef", "EOFinDef", source);
        }

        public int paramCnt() {
            return this.count;
        }

        public void addToMask(KtToken tok) {
            this.paramBuf.append(tok);
        }

        public void addParam() {
            this.matchCodes[this.count] = this.matchCode;
            this.paramMask[this.count++] = this.paramBuf.toTokenList();
            this.paramBuf = new KtTokenList.KtBuffer(10, 10);
        }

        public KtMacro toMacro(int prefixes) {
            int i = this.count;
            if (i > 0 || this.paramBuf.length() > 0) {
                this.paramMask[i++] = this.paramBuf.toTokenList();
            }
            KtTokenList[] mask = new KtTokenList[i];
            System.arraycopy(this.paramMask, 0, mask, 0, i);
            KtCharCode[] codes = null;
            if (this.count > 0) {
                codes = new KtCharCode[this.count];
                System.arraycopy(this.matchCodes, 0, codes, 0, this.count);
            }
            KtTokenList body = this.bodyBuf != null ? this.bodyBuf.toTokenList() : KtTokenList.EMPTY;
            return new KtMacro(mask, codes, body, prefixes);
        }

        @Override
        protected void tryToFix() {
            KtCommandBase.insertTokenWithoutCleaning(KtRightBraceToken.TOKEN);
        }

        @Override
        protected void reportRunAway() {
            KtCommandBase.runAway("definition", this);
        }

        @Override
        public void addOn(KtLog log, int maxCount) {
            this.toMacro(0).addMaxOn(log, maxCount);
        }
    }
}

