/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.node.KtAnyBoxNode;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtChrKernNode;
import com.whitemagicsoftware.keentype.node.KtGlueSetting;
import com.whitemagicsoftware.keentype.node.KtHSkipNode;
import com.whitemagicsoftware.keentype.node.KtHorizIterator;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtSizesEvaluator;
import com.whitemagicsoftware.keentype.node.KtTypesetter;
import com.whitemagicsoftware.keentype.node.KtVisibleSummarizer;

public class KtHBoxNode
extends KtAnyBoxNode {
    public static final KtHBoxNode EMPTY = new KtHBoxNode(KtBoxSizes.ZERO, KtGlueSetting.NATURAL, KtNodeList.EMPTY);

    public KtHBoxNode(KtBoxSizes sizes, KtGlueSetting setting, KtNodeList list) {
        super(sizes, setting, list);
    }

    @Override
    public final boolean isHBox() {
        return true;
    }

    @Override
    public String getDesc() {
        return "hbox";
    }

    @Override
    protected void moveStart(KtTypesetter setter) {
        setter.moveLeft(this.getLeftX());
    }

    @Override
    protected void movePrev(KtTypesetter setter, KtNode node) {
        setter.moveRight(node.getLeftX(this.setting));
    }

    @Override
    protected void movePast(KtTypesetter setter, KtNode node) {
        setter.moveRight(node.getWidth(this.setting));
    }

    @Override
    public KtBox pretendSizesCopy(KtBoxSizes sizes) {
        return new KtHBoxNode(sizes, this.setting, this.list);
    }

    public static KtHBoxNode packedOf(KtNodeList list) {
        return new KtHBoxNode(KtHorizIterator.naturalSizes(list.nodes()), KtGlueSetting.NATURAL, list);
    }

    public static KtHBoxNode packedOf(KtNode node) {
        return KtHBoxNode.packedOf(new KtNodeList(node));
    }

    @Override
    public KtNode trailingKernSpared() {
        return this.list.length() == 2 && this.list.nodeAt(0).kernAfterCanBeSpared() && this.list.nodeAt(1).isKernThatCanBeSpared() ? new KtHBoxNode(this.sizes, this.setting, new KtNodeList(this.list.nodeAt(0))) : this;
    }

    @Override
    public KtNode reboxedToWidth(KtDimen width) {
        if (this.getWidth().equals(width)) {
            return this;
        }
        if (this.list.isEmpty()) {
            return this.pretendingWidth(width);
        }
        KtNodeList forPacking = this.list;
        if (this.list.length() == 1 && this.list.nodeAt(0).kernAfterCanBeSpared()) {
            KtNode node = this.list.nodeAt(0);
            KtDimen delta = this.getWidth().minus(node.getWidth());
            if (!delta.isZero()) {
                forPacking = new KtNodeList(2);
                forPacking.append(node).append(new KtChrKernNode(delta));
            }
        }
        return KtHBoxNode.packedToWidth(forPacking.nodes(), width);
    }

    public static KtNode reboxedToWidth(KtNode node, KtDimen width) {
        return node.getWidth().equals(width) ? node : KtHBoxNode.packedToWidth(KtNodeList.nodes(node), width);
    }

    private static KtHBoxNode packedToWidth(KtNodeEnum nodes, KtDimen width) {
        KtHSkipNode filler = new KtHSkipNode(KtGlue.valueOf(KtDimen.ZERO, KtDimen.UNITY, (byte)1, KtDimen.UNITY, (byte)1));
        KtNodeList list = new KtNodeList();
        list.append(filler).append(nodes).append(filler);
        KtSizesEvaluator pack = new KtSizesEvaluator();
        KtHorizIterator.summarize(list.nodes(), pack);
        width = width.minus(pack.getHeight());
        KtDimen size = pack.getBody().plus(pack.getDepth());
        pack.evaluate(width.minus(size), false);
        KtBoxSizes sizes = new KtBoxSizes(pack.getWidth(), width, pack.getLeftX(), pack.getHeight());
        return new KtHBoxNode(sizes, pack.getSetting(), list);
    }

    public KtDimen allegedlyVisibleWidth() {
        KtVisibleSummarizer summarizer = new KtVisibleSummarizer(this.setting);
        summarizer.summarize(this.list.nodes());
        return summarizer.getVisibleWidth();
    }

    public String toString() {
        return "HBox(" + String.valueOf(this.sizes) + "; " + String.valueOf(this.setting) + "; " + String.valueOf(this.list) + ")";
    }
}

