/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.node.KtHyphens;
import java.io.Serializable;

public abstract class KtLanguage
implements Serializable,
KtLoggable {
    public static final KtLanguage NULL = null;
    public static final char WORD_BOUNDARY = '\u0000';
    protected final int languageNumber;
    protected final int leftHyphenMin;
    protected final int rightHyphenMin;

    public KtLanguage(int ln, int lhm, int rhm) {
        this.languageNumber = ln;
        this.leftHyphenMin = lhm;
        this.rightHyphenMin = rhm;
    }

    public boolean isCommon() {
        return this.languageNumber == 0 && this.leftHyphenMin == 2 && this.rightHyphenMin == 3;
    }

    @Override
    public void addOn(KtLog log) {
        log.add("language").add(this.languageNumber).add(":hyphenmin").add(this.leftHyphenMin).add(',').add(this.rightHyphenMin);
    }

    public void addShortlyOn(KtLog log) {
        log.add(this.languageNumber).add(" (hyphenmin ").add(this.leftHyphenMin).add(',').add(this.rightHyphenMin).add(')');
    }

    public boolean isZero() {
        return this.languageNumber == 0;
    }

    public void addNumberOn(KtLog log) {
        log.add(this.languageNumber);
    }

    public boolean sameNumberAs(int number) {
        return this.languageNumber == number;
    }

    public abstract KtHyphens getHyphens(String var1);

    public abstract void setHyphException(String var1, int[] var2);

    public abstract boolean setHyphPattern(String var1, int[] var2);
}

