/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.typo.KtBuilderCommand;

class KtCharGiven
extends KtCommand
implements KtNum.KtProvider {
    private final KtCharCode code;
    private final String name;

    public KtCharGiven(KtCharCode code, String name) {
        this.code = code;
        this.name = name;
    }

    @Override
    public void exec(KtToken src) {
        KtBuilderCommand.handleChar(this.code, src);
    }

    @Override
    public KtCharCode charCodeToAdd() {
        return this.code;
    }

    @Override
    public boolean sameAs(KtCommand cmd) {
        return cmd instanceof KtCharGiven && this.code.match(((KtCharGiven)cmd).code);
    }

    @Override
    public void addOn(KtLog log) {
        log.addEsc(this.name).add('\"').add(Integer.toHexString(this.code.numValue()).toUpperCase());
    }

    @Override
    public boolean hasNumValue() {
        return true;
    }

    @Override
    public KtNum getNumValue() {
        return KtNum.valueOf(this.code.numValue());
    }

    public final String toString() {
        return "[character given: " + String.valueOf(this.code) + "]";
    }
}

