/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.builder.KtParBuilder;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtBreaker;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtGlueSetting;
import com.whitemagicsoftware.keentype.node.KtHBoxNode;
import com.whitemagicsoftware.keentype.node.KtHyphenNodeEnum;
import com.whitemagicsoftware.keentype.node.KtLanguage;
import com.whitemagicsoftware.keentype.node.KtLinesShape;
import com.whitemagicsoftware.keentype.node.KtNamedHSkipNode;
import com.whitemagicsoftware.keentype.node.KtNetDimen;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtPenaltyNode;
import com.whitemagicsoftware.keentype.node.KtVShiftNode;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;

public abstract class KtParagraph
extends KtTypoCommand {
    public static final int DIMP_PAR_INDENT = KtParagraph.newDimParam();
    public static final int TOKSP_EVERY_PAR = KtParagraph.newToksParam();
    public static final int INTP_INTER_LINE_PENALTY = KtParagraph.newIntParam();
    public static final int INTP_BROKEN_PENALTY = KtParagraph.newIntParam();
    public static final int INTP_CLUB_PENALTY = KtParagraph.newIntParam();
    public static final int INTP_WIDOW_PENALTY = KtParagraph.newIntParam();
    public static final int GLUEP_PAR_SKIP = KtParagraph.newGlueParam();
    public static final int BOOLP_TRACING_PARAGRAPHS = KtParagraph.newBoolParam();
    public static final int BOOLP_UC_HYPH = KtParagraph.newBoolParam();
    public static final int INTP_PRETOLERANCE = KtParagraph.newIntParam();
    public static final int INTP_TOLERANCE = KtParagraph.newIntParam();
    public static final int INTP_LOOSENESS = KtParagraph.newIntParam();
    public static final int INTP_LINE_PENALTY = KtParagraph.newIntParam();
    public static final int INTP_HYPHEN_PENALTY = KtParagraph.newIntParam();
    public static final int INTP_EX_HYPHEN_PENALTY = KtParagraph.newIntParam();
    public static final int INTP_ADJ_DEMERITS = KtParagraph.newIntParam();
    public static final int INTP_DOUBLE_HYPHEN_DEMERITS = KtParagraph.newIntParam();
    public static final int INTP_FINAL_HYPHEN_DEMERITS = KtParagraph.newIntParam();
    public static final int DIMP_EMERGENCY_STRETCH = KtParagraph.newDimParam();
    public static final int GLUEP_LEFT_SKIP = KtParagraph.newGlueParam();
    public static final int GLUEP_RIGHT_SKIP = KtParagraph.newGlueParam();
    public static final int GLUEP_PAR_FILL_SKIP = KtParagraph.newGlueParam();

    public static void makeIndent(KtBuilder bld) {
        bld.addBox(new KtHBoxNode(new KtBoxSizes(KtDimen.ZERO, KtParagraph.getConfig().getDimParam(DIMP_PAR_INDENT), KtDimen.ZERO, KtDimen.ZERO), KtGlueSetting.NATURAL, KtNodeList.EMPTY));
    }

    public static void start(boolean indent) {
        KtCommandBase.KtConfig cfg = KtParagraph.getConfig();
        KtBuilder old = KtParagraph.getBld();
        old.setPrevGraf(0);
        if (old.needsParSkip()) {
            old.addSkip(cfg.getGlueParam(GLUEP_PAR_SKIP), cfg.getGlueName(GLUEP_PAR_SKIP));
        }
        KtParBuilder par = new KtParBuilder(KtParagraph.currLineNumber(), KtParagraph.getTypoConfig().getLanguage());
        KtBuilder.push(par);
        if (indent) {
            KtParagraph.makeIndent(par);
        }
        cfg.getToksInserter(TOKSP_EVERY_PAR).insertToks();
        old.buildPage();
    }

    public static void finish() {
        KtBuilder parBld = KtParagraph.getBld();
        KtNodeList list = parBld.getParagraph();
        if (list != KtNodeList.NULL) {
            KtParagraph.lineBreak(list, parBld.getStartLine(), KtParagraph.getConfig().getIntParam(INTP_WIDOW_PENALTY), parBld.getInitLang(), KtDimen.NULL_PAR);
            KtParagraph.getTypoConfig().resetParagraph();
            KtParagraph.getIOHandler().resetErrorCount();
        }
    }

    public static void lineBreak(KtNodeList list, int startingLine, int widowPenalty, KtLanguage initLang, KtDimen.KtPar lastVisibleWidth) {
        if (list.isEmpty()) {
            KtBuilder.pop();
        } else {
            int threshold;
            KtCommandBase.KtConfig cfg = KtParagraph.getConfig();
            KtTypoCommand.KtConfig tcfg = KtParagraph.getTypoConfig();
            KtNode last = list.lastNode();
            if (last.isSkip()) {
                list.removeLastNode();
            }
            list.append(new KtPenaltyNode(KtNum.valueOf(10000)));
            list.append(new KtNamedHSkipNode(cfg.getGlueParam(GLUEP_PAR_FILL_SKIP), cfg.getGlueName(GLUEP_PAR_FILL_SKIP)));
            KtBuilder.pop();
            boolean marginSkipHadInfiniteShrink = false;
            boolean tracing = cfg.getBoolParam(BOOLP_TRACING_PARAGRAPHS);
            KtGlue left = cfg.getGlueParam(GLUEP_LEFT_SKIP);
            KtGlue right = cfg.getGlueParam(GLUEP_RIGHT_SKIP);
            if (left.getShrOrder() != 0 && !left.getShrink().isZero() || right.getShrOrder() != 0 && !right.getShrink().isZero()) {
                marginSkipHadInfiniteShrink = true;
                tcfg.setMarginSkipsShrinkFinite();
                left = cfg.getGlueParam(GLUEP_LEFT_SKIP);
                right = cfg.getGlueParam(GLUEP_RIGHT_SKIP);
            }
            KtNode leftSkip = left.isZero() ? KtNode.NULL : new KtNamedHSkipNode(left, cfg.getGlueName(GLUEP_LEFT_SKIP));
            KtNamedHSkipNode rightSkip = new KtNamedHSkipNode(right, cfg.getGlueName(GLUEP_RIGHT_SKIP));
            KtNetDimen background = new KtNetDimen(cfg.getGlueParam(GLUEP_LEFT_SKIP));
            background.add(cfg.getGlueParam(GLUEP_RIGHT_SKIP));
            KtLinesShape shape = tcfg.linesShape();
            KtBuilder bld = KtParagraph.getBld();
            int lineNo = bld.getPrevGraf();
            KtParBreaker breaker = new KtParBreaker(list.nodes(), shape, lineNo, cfg.getIntParam(INTP_LOOSENESS), cfg.getIntParam(INTP_LINE_PENALTY), cfg.getIntParam(INTP_HYPHEN_PENALTY), cfg.getIntParam(INTP_EX_HYPHEN_PENALTY), cfg.getIntParam(INTP_ADJ_DEMERITS), cfg.getIntParam(INTP_DOUBLE_HYPHEN_DEMERITS), cfg.getIntParam(INTP_FINAL_HYPHEN_DEMERITS), cfg.getBoolParam(BOOLP_TRACING_PARAGRAPHS));
            if (marginSkipHadInfiniteShrink) {
                breaker.infiniteShrinkageError();
            }
            if ((threshold = cfg.getIntParam(INTP_PRETOLERANCE)) >= 0) {
                if (tracing) {
                    diagLog.startLine().add("@firstpass");
                }
                breaker.breakToLines(background, threshold, false);
                if (!breaker.successfullyBroken() && tracing) {
                    diagLog.startLine().add("@secondpass");
                }
            }
            if (!breaker.successfullyBroken()) {
                KtDimen emergStr = cfg.getDimParam(DIMP_EMERGENCY_STRETCH);
                threshold = cfg.getIntParam(INTP_TOLERANCE);
                tcfg.preparePatterns();
                breaker.refeed(new KtHyphNodeEnum(list.nodes(), initLang, cfg.getBoolParam(BOOLP_UC_HYPH)));
                breaker.breakToLines(background, threshold, !emergStr.moreThan(0));
                if (!breaker.successfullyBroken()) {
                    if (tracing) {
                        diagLog.startLine().add("@emergencypass");
                    }
                    background.addStretch((byte)0, emergStr);
                    breaker.breakToLines(background, threshold, true);
                }
            }
            if (tracing) {
                diagLog.startLine().endLine();
            }
            if (breaker.hasMoreLines()) {
                KtDimen lastIndent;
                KtHBoxNode lastHBox;
                KtLinePacker packer = new KtLinePacker(startingLine);
                boolean club = true;
                boolean hyph = breaker.nextLineWasHyphenated();
                KtNodeList line = breaker.getNextLine();
                while (true) {
                    line.append(rightSkip);
                    if (leftSkip != KtNode.NULL) {
                        KtNodeList old = line;
                        line = new KtNodeList(leftSkip);
                        line.append(old);
                    }
                    KtNodeEnum mig = bld.wantsMigrations() ? line.extractedMigrations().nodes() : KtNodeList.EMPTY_ENUM;
                    KtNode box = lastHBox = packer.packHBox(line, shape.getWidth(lineNo), true);
                    lastIndent = shape.getIndent(lineNo);
                    box = KtVShiftNode.shiftingRight(box, lastIndent);
                    KtParagraph.appendBox(bld, box, mig, false);
                    ++lineNo;
                    if (!breaker.hasMoreLines()) break;
                    int pen = cfg.getIntParam(INTP_INTER_LINE_PENALTY);
                    if (club) {
                        pen += cfg.getIntParam(INTP_CLUB_PENALTY);
                    }
                    if (hyph) {
                        pen += cfg.getIntParam(INTP_BROKEN_PENALTY);
                    }
                    club = false;
                    hyph = breaker.nextLineWasHyphenated();
                    line = breaker.getNextLine();
                    if (!breaker.hasMoreLines()) {
                        pen += widowPenalty;
                    }
                    if (pen == 0) continue;
                    bld.addPenalty(KtNum.valueOf(pen));
                }
                bld.setPrevGraf(lineNo);
                if (lastVisibleWidth != KtDimen.NULL_PAR) {
                    KtDimen visible = lastHBox.allegedlyVisibleWidth();
                    if (visible != KtDimen.NULL) {
                        visible = visible.plus(lastIndent);
                    }
                    lastVisibleWidth.set(visible);
                }
            }
        }
    }

    private static class KtParBreaker
    extends KtBreaker {
        private final boolean tracing;
        private int lastPrinted;
        private KtFontMetric lastMetric;
        private boolean infiniteShrinkageSeen;

        public KtParBreaker(KtNodeEnum nodeEnum, KtLinesShape shape, int firstLineNo, int looseness, int linePen, int hyphPen, int exHyphPen, int adjDem, int dblHyphDem, int finHyphDem, boolean tracing) {
            super(nodeEnum, shape, firstLineNo, looseness, linePen, hyphPen, exHyphPen, adjDem, dblHyphDem, finHyphDem);
            this.tracing = tracing;
        }

        @Override
        protected void reset() {
            super.reset();
            this.lastPrinted = -1;
            this.lastMetric = KtFontMetric.NULL;
        }

        @Override
        protected void traceBreak(int idx, int serial, int bad, int pen, int dem, boolean artificial) {
            if (this.tracing) {
                if (this.lastPrinted < idx) {
                    KtCommandBase.diagLog.startLine();
                    do {
                        if (!this.stillNodeAt(++this.lastPrinted)) continue;
                        this.lastMetric = this.nodeAt(this.lastPrinted).addShortlyOn(KtCommandBase.diagLog, this.lastMetric);
                    } while (this.lastPrinted < idx);
                }
                KtCommandBase.diagLog.startLine().add('@');
                if (this.stillNodeAt(idx)) {
                    this.nodeAt(idx).addBreakDescOn(KtCommandBase.diagLog);
                } else {
                    KtCommandBase.diagLog.addEsc("par");
                }
                KtCommandBase.diagLog.add(" via @@").add(serial).add(" b=");
                if (bad > 10000) {
                    KtCommandBase.diagLog.add('*');
                } else {
                    KtCommandBase.diagLog.add(bad);
                }
                KtCommandBase.diagLog.add(" p=").add(pen).add(" d=");
                if (artificial) {
                    KtCommandBase.diagLog.add('*');
                } else {
                    KtCommandBase.diagLog.add(dem);
                }
            }
        }

        @Override
        protected void traceBreak(KtBreaker.KtBreak brk) {
            if (this.tracing) {
                KtCommandBase.diagLog.startLine().add("@@").add(brk.serial).add(": line ").add(brk.lineNo).add('.').add(brk.fitness);
                if (brk.hyphenated) {
                    KtCommandBase.diagLog.add('-');
                }
                KtCommandBase.diagLog.add(" t=").add(brk.demerits).add(" -> @@").add(brk.prev.serial);
            }
        }

        protected void infiniteShrinkageError() {
            if (!this.infiniteShrinkageSeen) {
                KtCommandBase.error("InfShringInPar");
                this.infiniteShrinkageSeen = true;
            }
        }
    }

    private static class KtHyphNodeEnum
    extends KtHyphenNodeEnum {
        public KtHyphNodeEnum(KtNodeEnum in, KtLanguage lang, boolean ucHyph) {
            super(in, lang, ucHyph);
        }

        @Override
        protected KtCharCode hyphenChar(KtFontMetric metric) {
            KtNum num = metric.getNumParam(0);
            return num != KtNum.NULL ? KtToken.makeCharCode(num.intVal()) : KtCharCode.NULL;
        }

        @Override
        protected void complain(KtFontMetric metric, KtCharCode code) {
            KtTypoCommand.charWarning(metric, code);
        }
    }

    private static class KtLinePacker
    extends KtTypoCommand.KtHBoxPacker {
        protected final int startLine;

        public KtLinePacker(int startLine) {
            this.startLine = startLine;
        }

        @Override
        protected void reportLocation(KtLog log) {
            log.add("in paragraph at lines ").add(this.startLine).add("--").add(KtCommandBase.currLineNumber());
        }
    }
}

