/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.command.KtOtherToken;
import com.whitemagicsoftware.keentype.command.KtSpaceToken;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.io.KtMaxLoggable;
import com.whitemagicsoftware.keentype.io.KtName;
import java.io.Serializable;
import java.util.Vector;

public class KtTokenList
implements Serializable,
KtLoggable,
KtMaxLoggable {
    public static final KtTokenList NULL = null;
    public static final KtTokenList EMPTY = new KtTokenList();
    private final KtToken[] tokens;

    private static KtToken tokenFor(char chr) {
        if (chr == ' ') {
            return KtSpaceToken.TOKEN;
        }
        return new KtOtherToken(KtToken.makeCharCode(chr));
    }

    private static KtToken tokenFor(KtCharCode code) {
        if (code.match(' ')) {
            return KtSpaceToken.TOKEN;
        }
        return new KtOtherToken(code);
    }

    public KtTokenList() {
        this.tokens = new KtToken[0];
    }

    public KtTokenList(KtToken[] tokens) {
        this.tokens = tokens;
    }

    public KtTokenList(KtToken[] tokens, int offset, int count) {
        this.tokens = new KtToken[count];
        System.arraycopy(tokens, offset, this.tokens, 0, count);
    }

    public KtTokenList(KtToken tok) {
        this.tokens = new KtToken[1];
        this.tokens[0] = tok;
    }

    public KtTokenList(String str) {
        this.tokens = new KtToken[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            this.tokens[i] = KtTokenList.tokenFor(str.charAt(i));
        }
    }

    public KtTokenList(KtName name) {
        this.tokens = new KtToken[name.length()];
        for (int i = 0; i < name.length(); ++i) {
            this.tokens[i] = KtTokenList.tokenFor(name.codeAt(i));
        }
    }

    public final int length() {
        return this.tokens.length;
    }

    public final boolean isEmpty() {
        return this.length() == 0;
    }

    public final KtToken tokenAt(int idx) {
        return this.tokens[idx];
    }

    public final boolean match(KtTokenList list) {
        if (this.length() == list.length()) {
            for (int i = 0; i < this.length(); ++i) {
                if (this.tokenAt(i).match(list.tokenAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void addOn(KtLog log) {
        for (int i = 0; i < this.length(); ++i) {
            this.tokenAt(i).addProperlyOn(log);
        }
    }

    @Override
    public void addOn(KtLog log, int maxCount) {
        int i;
        maxCount += log.getCount();
        for (i = 0; i < this.length() && log.getCount() < maxCount; ++i) {
            this.tokenAt(i).addProperlyOn(log);
        }
        if (i < this.length()) {
            log.addEsc("ETC.");
        }
    }

    public void addContext(KtLog left, KtLog right, int pos, int maxCount) {
        int i;
        KtLog log = left;
        maxCount += log.getCount();
        for (i = 0; i < this.length() && log.getCount() < maxCount; ++i) {
            if (i == pos) {
                maxCount -= log.getCount();
                log = right;
                maxCount += log.getCount();
            }
            this.tokenAt(i).addProperlyOn(log);
        }
        if (i < this.length()) {
            log.addEsc("ETC.");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.length()) {
            buf.append(this.tokenAt(i++));
        }
        return buf.toString();
    }

    public static class KtBuffer
    implements KtLoggable,
    KtMaxLoggable {
        protected Vector<KtToken> data;

        public KtBuffer() {
            this.data = new Vector();
        }

        public KtBuffer(int initCap) {
            this.data = new Vector(initCap);
        }

        public KtBuffer(int initCap, int capIncrement) {
            this.data = new Vector(initCap, capIncrement);
        }

        public KtBuffer append(KtToken tok) {
            this.data.addElement(tok);
            return this;
        }

        public KtBuffer append(char chr) {
            return this.append(KtTokenList.tokenFor(chr));
        }

        public KtBuffer append(KtCharCode code) {
            return this.append(KtTokenList.tokenFor(code));
        }

        public KtBuffer append(KtToken[] tokens, int offset, int count) {
            this.data.ensureCapacity(this.data.size() + count);
            while (count-- > 0) {
                this.data.addElement(tokens[offset++]);
            }
            return this;
        }

        public KtBuffer append(KtToken[] tokens) {
            return this.append(tokens, 0, tokens.length);
        }

        public KtBuffer append(KtTokenList list) {
            return this.append(list.tokens);
        }

        public void insertTokenAt(KtToken tok, int idx) {
            this.data.insertElementAt(tok, idx);
        }

        public void insertTokenAt(KtCharCode code, int idx) {
            this.data.insertElementAt(KtTokenList.tokenFor(code), idx);
        }

        public void insertTokenAt(char chr, int idx) {
            this.data.insertElementAt(KtTokenList.tokenFor(chr), idx);
        }

        public int length() {
            return this.data.size();
        }

        public void setLength(int size) {
            this.data.setSize(size);
        }

        public KtToken tokenAt(int idx) {
            return this.data.elementAt(idx);
        }

        public KtToken lastToken() {
            return this.data.elementAt(this.data.size() - 1);
        }

        public void removeTokenAt(int idx) {
            this.data.removeElementAt(idx);
        }

        public void removeLastToken() {
            this.data.removeElementAt(this.data.size() - 1);
        }

        public void getTokens(int beg, int end, KtToken[] dst, int offset) {
            while (beg < end) {
                dst[offset++] = this.tokenAt(beg++);
            }
        }

        public KtTokenList toTokenList() {
            if (this.length() == 0) {
                return EMPTY;
            }
            Object[] tokens = new KtToken[this.length()];
            this.data.copyInto(tokens);
            return new KtTokenList((KtToken[])tokens);
        }

        @Override
        public void addOn(KtLog log) {
            this.toTokenList().addOn(log);
        }

        @Override
        public void addOn(KtLog log, int maxCount) {
            this.toTokenList().addOn(log, maxCount);
        }
    }

    public static interface KtInserter {
        public void insertToks();

        public boolean isEmpty();
    }

    public static interface KtMaintainer
    extends KtProvider {
        public void setToksValue(KtTokenList var1);

        public boolean isEmpty();
    }

    public static interface KtProvider {
        public KtTokenList getToksValue();
    }
}

