/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.lib;

import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.builder.KtPageBuilder;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtCondPrim;
import com.whitemagicsoftware.keentype.command.KtFileName;
import com.whitemagicsoftware.keentype.command.KtLineInputTokenizer;
import com.whitemagicsoftware.keentype.command.KtTokenizerStack;
import com.whitemagicsoftware.keentype.io.KtInputLine;
import com.whitemagicsoftware.keentype.io.KtLineInput;
import com.whitemagicsoftware.keentype.math.KtMathPrim;
import com.whitemagicsoftware.keentype.svg.KtSvgTypesetter;
import com.whitemagicsoftware.keentype.tex.KtConfig;
import com.whitemagicsoftware.keentype.tex.KtFileFormat;
import com.whitemagicsoftware.keentype.tex.KtFileOpener;
import com.whitemagicsoftware.keentype.tex.KtPrimitives;
import com.whitemagicsoftware.keentype.tex.KtTeXCharMapper;
import com.whitemagicsoftware.keentype.tex.KtTeXContextDisplay;
import com.whitemagicsoftware.keentype.tex.KtTeXFontHandler;
import com.whitemagicsoftware.keentype.tex.KtTeXIOHandler;
import com.whitemagicsoftware.keentype.tex.KtTeXTokenMaker;
import com.whitemagicsoftware.keentype.typo.KtPage;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public final class KeenType {
    private final ByteArrayOutputStream mOut = new ByteArrayOutputStream();
    private final KtFileName mFileName = new KtTeXCharMapper.KtTeXFileName("ext/math");
    private final KtTeXIOHandler mHandler;
    private final KtTeXCharMapper mMapper = new KtTeXCharMapper();
    private final KtPrimitives mConfig = new KtPrimitives();

    public KeenType() {
        this(true);
    }

    public KeenType(boolean fullPage) {
        KtCommand.setConfig(this.mConfig.getCommandConfig());
        KtTypoCommand.setTypoConfig(this.mConfig.getTypoConfig());
        KtMathPrim.setMathConfig(this.mConfig.getMathConfig());
        KtTeXCharMapper.setConfig(this.mConfig.getCharMapConfig());
        KtBuilder.push(new KtPageBuilder(0, KtPage.getPageSplit()));
        KtTeXTokenMaker maker = new KtTeXTokenMaker(this.mConfig);
        KtTeXContextDisplay display = new KtTeXContextDisplay(this.mConfig, this.mMapper, this.mMapper);
        KtConfig ioConfig = this.mConfig.getIOHandConfig();
        KtTeXFontHandler fontHand = new KtTeXFontHandler(this.mConfig.getFontHandConfig());
        KtSvgTypesetter typeSetter = new KtSvgTypesetter(fontHand, fullPage);
        this.mHandler = new KtTeXIOHandler(ioConfig, this.mMapper, maker, display, typeSetter);
        KtTypoCommand.setTypoHandler(fontHand);
        KtTypoCommand.setTypesetter(typeSetter);
        KtCommand.setIOHandler(this.mHandler);
        try (InputStream fileInput = KtFileOpener.readFile(this.mFileName, KtFileFormat.INPUT_EXT);){
            Reader fileReader = KtTeXIOHandler.makeReader(fileInput);
            KtLineInput input = new KtLineInput(fileReader, (KtInputLine.KtMapper)this.mMapper);
            KtTokenizerStack stack = new KtTokenizerStack();
            stack.push(new KtLineInputTokenizer(input, this.mHandler, this.mFileName));
            KtCommand.setInput(input);
            KtCommand.setTokStack(stack);
            KtCommand.mainLoop();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toSvg(String expression) {
        return this.toSvg(expression, 1.0);
    }

    public String toSvg(String expression, double scale) {
        StringReader reader = new StringReader(expression + "\\end");
        KtLineInput input = new KtLineInput(reader, (KtInputLine.KtMapper)this.mMapper);
        KtTokenizerStack stack = new KtTokenizerStack();
        stack.push(new KtLineInputTokenizer(input, this.mHandler, this.mFileName));
        KtCommand.setInput(input);
        KtCommand.setTokStack(stack);
        this.mHandler.startDocument(this.mOut);
        this.mHandler.setScale(scale);
        KtCommand.mainLoop();
        this.mHandler.stopDocument();
        KtCommand.cleanUp();
        KtCondPrim.cleanUp();
        String result = this.mOut.toString(StandardCharsets.UTF_8);
        this.mOut.reset();
        return result;
    }
}

