/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.json-io.util.io;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.jsign.json-io.util.io.JsonIoException;
import net.jsign.json-io.util.io.Readers;

public class JsonObject<K, V>
extends LinkedHashMap<K, V> {
    static Set<String> primitives = new HashSet<String>();
    static Set<String> primitiveWrappers = new HashSet<String>();
    Object target;
    boolean isMap = false;
    String type;
    long id = -1L;
    int line;
    int col;

    static {
        primitives.add("boolean");
        primitives.add("byte");
        primitives.add("char");
        primitives.add("double");
        primitives.add("float");
        primitives.add("int");
        primitives.add("long");
        primitives.add("short");
        primitiveWrappers.add("java.lang.Boolean");
        primitiveWrappers.add("java.lang.Byte");
        primitiveWrappers.add("java.lang.Character");
        primitiveWrappers.add("java.lang.Double");
        primitiveWrappers.add("java.lang.Float");
        primitiveWrappers.add("java.lang.Integer");
        primitiveWrappers.add("java.lang.Long");
        primitiveWrappers.add("java.lang.Short");
    }

    public long getId() {
        return this.id;
    }

    public boolean hasId() {
        return this.id != -1L;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Class getTargetClass() {
        return this.target.getClass();
    }

    public boolean isLogicalPrimitive() {
        return primitiveWrappers.contains(this.type) || primitives.contains(this.type) || "date".equals(this.type) || "java.math.BigInteger".equals(this.type) || "java.math.BigDecimal".equals(this.type);
    }

    public Object getPrimitiveValue() {
        if ("boolean".equals(this.type) || "double".equals(this.type) || "long".equals(this.type)) {
            return this.get("value");
        }
        if ("byte".equals(this.type)) {
            Number b = (Number)this.get("value");
            return b.byteValue();
        }
        if ("char".equals(this.type)) {
            String c = (String)this.get("value");
            return Character.valueOf(c.charAt(0));
        }
        if ("float".equals(this.type)) {
            Number f = (Number)this.get("value");
            return Float.valueOf(f.floatValue());
        }
        if ("int".equals(this.type)) {
            Number integer = (Number)this.get("value");
            return integer.intValue();
        }
        if ("short".equals(this.type)) {
            Number s = (Number)this.get("value");
            return s.shortValue();
        }
        if ("date".equals(this.type)) {
            Object date = this.get("value");
            if (date instanceof Long) {
                return new Date((Long)date);
            }
            if (date instanceof String) {
                return Readers.DateReader.parseDate((String)date);
            }
            throw new JsonIoException("Unknown date type: " + this.type);
        }
        if ("java.math.BigInteger".equals(this.type)) {
            Object value = this.get("value");
            return Readers.bigIntegerFrom(value);
        }
        if ("java.math.BigDecimal".equals(this.type)) {
            Object value = this.get("value");
            return Readers.bigDecimalFrom(value);
        }
        throw new JsonIoException("Invalid primitive type, line " + this.line + ", col " + this.col);
    }

    public boolean isReference() {
        return this.containsKey("@ref");
    }

    public Long getReferenceId() {
        return (Long)this.get("@ref");
    }

    public boolean isMap() {
        return this.isMap || this.target instanceof Map;
    }

    public boolean isCollection() {
        if (this.target instanceof Collection) {
            return true;
        }
        if (this.containsKey("@items") && !this.containsKey("@keys")) {
            return this.type != null && !this.type.contains("[");
        }
        return false;
    }

    public boolean isArray() {
        if (this.target == null) {
            if (this.type != null) {
                return this.type.contains("[");
            }
            return this.containsKey("@items") && !this.containsKey("@keys");
        }
        return this.target.getClass().isArray();
    }

    public Object[] getArray() {
        return (Object[])this.get("@items");
    }

    public int getLength() {
        if (this.isArray()) {
            if (this.target == null) {
                Object[] items = (Object[])this.get("@items");
                return items == null ? 0 : items.length;
            }
            return Array.getLength(this.target);
        }
        if (this.isCollection() || this.isMap()) {
            Object[] items = (Object[])this.get("@items");
            return items == null ? 0 : items.length;
        }
        throw new JsonIoException("getLength() called on a non-collection, line " + this.line + ", col " + this.col);
    }

    public Class getComponentType() {
        return this.target.getClass().getComponentType();
    }

    void moveBytesToMate() {
        byte[] bytes = (byte[])this.target;
        Object[] items = this.getArray();
        int len = items.length;
        int i = 0;
        while (i < len) {
            bytes[i] = ((Number)items[i]).byteValue();
            ++i;
        }
    }

    void moveCharsToMate() {
        Object[] items = this.getArray();
        if (items == null) {
            this.target = null;
        } else if (items.length == 0) {
            this.target = new char[0];
        } else if (items.length == 1) {
            String s = (String)items[0];
            this.target = s.toCharArray();
        } else {
            throw new JsonIoException("char[] should only have one String in the [], found " + items.length + ", line " + this.line + ", col " + this.col);
        }
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            return super.put(null, value);
        }
        if (key.equals("@type")) {
            String oldType = this.type;
            this.type = (String)value;
            return (V)oldType;
        }
        if (key.equals("@id")) {
            Long oldId = this.id;
            this.id = (Long)value;
            return (V)oldId;
        }
        if ("@items".equals(key) && this.containsKey("@keys") || "@keys".equals(key) && this.containsKey("@items")) {
            this.isMap = true;
        }
        return super.put(key, value);
    }

    @Override
    public void clear() {
        super.clear();
        this.type = null;
    }

    void clearArray() {
        this.remove("@items");
    }

    @Override
    public int size() {
        if (this.containsKey("@items")) {
            Object value = this.get("@items");
            if (value instanceof Object[]) {
                return ((Object[])value).length;
            }
            if (value == null) {
                return 0;
            }
            throw new JsonIoException("JsonObject with @items, but no array [] associated to it, line " + this.line + ", col " + this.col);
        }
        if (this.containsKey("@ref")) {
            return 0;
        }
        return super.size();
    }
}

