/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.align;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtAnyBoxedNode;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtGlueSetting;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtSizesEvaluator;

public class KtAnyUnsetNode
extends KtAnyBoxedNode {
    protected final KtNodeList list;
    protected final int spanCount;
    protected final KtDimen stretch;
    protected final byte strOrder;
    protected final KtDimen shrink;
    protected final byte shrOrder;

    public KtAnyUnsetNode(KtBoxSizes sizes, KtNodeList list, int spanCount, KtDimen stretch, byte strOrder, KtDimen shrink, byte shrOrder) {
        super(sizes);
        this.list = list;
        this.spanCount = spanCount;
        this.stretch = stretch;
        this.strOrder = strOrder;
        this.shrink = shrink;
        this.shrOrder = shrOrder;
    }

    public KtAnyUnsetNode(KtBoxSizes sizes, KtNodeList list) {
        this(sizes, list, 0, KtDimen.ZERO, 0, KtDimen.ZERO, 0);
    }

    public KtAnyUnsetNode() {
        this(KtBoxSizes.ZERO, KtNodeList.EMPTY);
    }

    public KtNodeList getList() {
        return this.list;
    }

    public int getSpanCount() {
        return this.spanCount;
    }

    @Override
    public void addOn(KtLog log, KtCntxLog cntx) {
        log.addEsc(this.getDesc()).add(this.sizes);
        StringBuffer buf = new StringBuffer(80);
        if (this.spanCount != 0) {
            buf.append(" (").append(this.spanCount + 1).append(" columns)");
        }
        if (!this.stretch.isZero()) {
            KtGlue.append(buf.append(", stretch "), this.stretch, this.strOrder, null);
        }
        if (!this.shrink.isZero()) {
            KtGlue.append(buf.append(", shrink "), this.shrink, this.shrOrder, null);
        }
        log.add(buf.toString());
        cntx.addOn(log, this.list.nodes());
    }

    public String getDesc() {
        return "unsetbox";
    }

    public KtGlueSetting getSetting(KtDimen excess) {
        KtSizesEvaluator pack = new KtSizesEvaluator();
        pack.addStretch(this.stretch, this.strOrder);
        pack.addShrink(this.shrink, this.shrOrder);
        pack.evaluate(excess, false);
        return pack.getSetting();
    }
}

