/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.builder;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.builder.KtListBuilder;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtBoxLeaders;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtLeaders;
import com.whitemagicsoftware.keentype.node.KtNamedVSkipNode;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtRuleNode;
import com.whitemagicsoftware.keentype.node.KtVKernNode;
import com.whitemagicsoftware.keentype.node.KtVLeadRuleNode;
import com.whitemagicsoftware.keentype.node.KtVLeadersNode;
import com.whitemagicsoftware.keentype.node.KtVSkipNode;

public abstract class KtVertBuilder
extends KtListBuilder {
    public static final KtDimen IGNORE_DEPTH = KtDimen.valueOf(-1000);
    private int prevGraf = 0;
    private KtDimen prevDepth = IGNORE_DEPTH;

    protected KtVertBuilder(int line, KtNodeList list) {
        super(line, list);
    }

    protected KtVertBuilder(int line) {
        super(line);
    }

    @Override
    public boolean isVertical() {
        return true;
    }

    @Override
    public boolean wantsMigrations() {
        return true;
    }

    @Override
    public void addKern(KtDimen kern) {
        this.addNode(new KtVKernNode(kern));
    }

    @Override
    public void addSkip(KtGlue skip) {
        this.addNode(new KtVSkipNode(skip));
    }

    @Override
    public void addNamedSkip(KtGlue skip, String name) {
        this.addNode(new KtNamedVSkipNode(skip, name));
    }

    @Override
    public void addRule(KtBoxSizes sizes) {
        this.addNode(new KtRuleNode(sizes));
        this.uncheckedSetPrevDepth(IGNORE_DEPTH);
    }

    @Override
    public void addLeaders(KtGlue skip, KtLeaders lead) {
        this.addNode(new KtVLeadersNode(skip, lead));
    }

    @Override
    public void addLeadRule(KtGlue skip, KtBoxSizes sizes, String desc) {
        this.addNode(new KtVLeadRuleNode(skip, sizes, desc));
    }

    @Override
    public KtBoxLeaders.KtMover getBoxLeadMover() {
        return KtVLeadersNode.BOX_MOVER;
    }

    @Override
    public void addBox(KtNode box) {
        super.addBox(box);
        this.uncheckedSetPrevDepth(box.getDepth());
    }

    @Override
    protected KtNodeEnum unBoxList(KtBox box) {
        return box.getVertList();
    }

    @Override
    public int getPrevGraf() {
        return this.prevGraf;
    }

    @Override
    public void setPrevGraf(int pg) {
        this.prevGraf = pg;
    }

    @Override
    public KtDimen getPrevDepth() {
        return this.prevDepth;
    }

    protected void uncheckedSetPrevDepth(KtDimen pd) {
        this.prevDepth = pd;
    }

    @Override
    public KtDimen nearestValidPrevDepth() {
        return this.prevDepth;
    }

    @Override
    public void setPrevDepth(KtDimen pd) {
        if (pd != KtDimen.NULL) {
            this.prevDepth = pd;
        }
    }

    @Override
    public boolean needsParSkip() {
        return !this.list.isEmpty();
    }

    @Override
    protected void specialShow(KtLog log) {
        log.startLine().add("prevdepth ");
        if (this.getPrevDepth().moreThan(IGNORE_DEPTH)) {
            log.add(this.getPrevDepth().toString());
        } else {
            log.add("ignored");
        }
        if (this.prevGraf != 0) {
            log.add(", prevgraf ").add(this.prevGraf).add(this.prevGraf == 1 ? " line" : " lines");
        }
    }
}

