/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.base.KtBoolPar;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtInpTokChecker;
import com.whitemagicsoftware.keentype.command.KtSpaceToken;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtLoggable;

public abstract class KtBaseToksChecker
implements KtInpTokChecker {
    protected final String tokError;
    protected final String eofError;
    protected final KtLoggable source;

    public KtBaseToksChecker(String tokErr, String eofErr, KtLoggable src) {
        this.tokError = tokErr;
        this.eofError = eofErr;
        this.source = src;
    }

    @Override
    public KtToken checkToken(KtToken tok, KtBoolPar canExpand) {
        if (KtCommand.meaningOf(tok, canExpand.get()).isOuter()) {
            this.handleOuterToken(tok);
            this.reportError(this.tokError);
            canExpand.set(true);
            return KtSpaceToken.TOKEN;
        }
        return tok;
    }

    @Override
    public void checkEndOfFile() {
        this.reportError(this.eofError);
    }

    protected void reportError(String ident) {
        this.tryToFix();
        this.reportRunAway();
        KtLoggable[] params = new KtLoggable[]{this.source};
        KtCommand.nonDelError(ident, params);
    }

    protected void handleOuterToken(KtToken tok) {
        KtCommand.backTokenWithoutCleaning(tok);
    }

    protected abstract void tryToFix();

    protected abstract void reportRunAway();
}

