/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.io;

import com.whitemagicsoftware.keentype.io.KtBaseLineOutput;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import java.io.IOException;
import java.io.Writer;

public final class KtWriterLineOutput
extends KtBaseLineOutput
implements KtCharCode.KtCharWriter {
    private final Writer out;
    private final KtCharCode.KtMaker maker;
    private final boolean worryRoom;
    private final int maxLineChars;
    private int numLineChars = 0;
    private final String lineSeparator;
    private boolean trouble = false;

    public KtWriterLineOutput(Writer out, KtCharCode.KtMaker maker, boolean worryRoom, int maxLineChars) {
        this.out = out;
        this.maker = maker;
        this.worryRoom = worryRoom && maxLineChars > 0;
        this.maxLineChars = maxLineChars;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public KtWriterLineOutput(Writer out, KtCharCode.KtMaker maker) {
        this(out, maker, false, 0);
    }

    @Override
    public void add(KtCharCode code) {
        if (code.isNewLine()) {
            this.endLine();
        } else {
            code.writeExpChars(this);
        }
    }

    @Override
    public void add(char chr) {
        if (this.maker.isNewLine(chr)) {
            this.endLine();
        } else {
            this.maker.writeExpChars(chr, this);
        }
    }

    @Override
    public void writeChar(char chr) {
        try {
            this.out.write(chr);
            ++this.charCount;
            ++this.numLineChars;
            if (this.maxLineChars > 0 && this.numLineChars >= this.maxLineChars) {
                this.endLine();
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public void addRaw(String str) {
        try {
            this.out.write(str);
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void endLine() {
        try {
            this.out.write(this.lineSeparator);
            this.out.flush();
        }
        catch (IOException x) {
            this.trouble = true;
        }
        this.numLineChars = 0;
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void setStartLine() {
        this.numLineChars = 0;
    }

    @Override
    public boolean isStartLine() {
        return this.numLineChars == 0;
    }

    @Override
    public boolean stillFits(int count) {
        return !this.worryRoom || this.numLineChars + count <= this.maxLineChars;
    }
}

