/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.math;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.noad.KtDelFractionNoad;
import com.whitemagicsoftware.keentype.noad.KtDelimiter;
import com.whitemagicsoftware.keentype.noad.KtEmptyField;
import com.whitemagicsoftware.keentype.noad.KtField;
import com.whitemagicsoftware.keentype.noad.KtFractionNoad;
import com.whitemagicsoftware.keentype.noad.KtNoad;
import com.whitemagicsoftware.keentype.noad.KtNoadList;
import com.whitemagicsoftware.keentype.noad.KtNoadListField;
import com.whitemagicsoftware.keentype.noad.KtNodeField;
import com.whitemagicsoftware.keentype.noad.KtOrdNoad;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtBoxLeaders;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtHKernNode;
import com.whitemagicsoftware.keentype.node.KtHLeadRuleNode;
import com.whitemagicsoftware.keentype.node.KtHLeadersNode;
import com.whitemagicsoftware.keentype.node.KtHSkipNode;
import com.whitemagicsoftware.keentype.node.KtLeaders;
import com.whitemagicsoftware.keentype.node.KtNamedHSkipNode;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtRuleNode;

public abstract class KtMathBuilder
extends KtBuilder {
    protected KtNoadList list;
    protected final int startLine;
    protected final KtNoad leftDelim;
    private KtNoadList numerator = KtNoadList.NULL;
    private KtDimen thickness;
    private KtDelimiter fractLeft = KtDelimiter.NULL;
    private KtDelimiter fractRight = KtDelimiter.NULL;

    protected KtMathBuilder(int startLine, KtNoadList list, KtNoad leftDelim) {
        this.startLine = startLine;
        this.list = list;
        this.leftDelim = leftDelim;
    }

    protected KtMathBuilder(int startLine, KtNoadList list) {
        this(startLine, list, KtNoad.NULL);
    }

    protected KtMathBuilder(int startLine, KtNoad leftNoad) {
        this(startLine, new KtNoadList(), leftNoad);
    }

    protected KtMathBuilder(int startLine) {
        this(startLine, new KtNoadList());
    }

    public void addNoad(KtNoad noad) {
        this.list.append(noad);
    }

    public KtNoad lastNoad() {
        return this.list.lastNoad();
    }

    public void removeLastNoad() {
        this.list.removeLastNoad();
    }

    public void replaceLastNoad(KtNoad noad) {
        this.list.replaceLastNoad(noad);
    }

    @Override
    public void addNode(KtNode node) {
        this.list.append(node);
    }

    @Override
    public void addNodes(KtNodeEnum nodes) {
        this.list.append(nodes);
    }

    @Override
    public KtNode lastNode() {
        return this.list.lastNode();
    }

    @Override
    public void removeLastNode() {
        this.list.removeLastNode();
    }

    @Override
    public KtNode lastSpecialNode() {
        return this.list.lastSpecialNode();
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public boolean unBox(KtBox box) {
        return false;
    }

    @Override
    public boolean isMath() {
        return true;
    }

    @Override
    public boolean isCharAllowed() {
        return true;
    }

    @Override
    public boolean forbidsThirdPartOfDiscretionary() {
        return true;
    }

    @Override
    public void addKern(KtDimen kern) {
        this.addNode(new KtHKernNode(kern));
    }

    @Override
    public void addSkip(KtGlue skip) {
        this.addNode(new KtHSkipNode(skip));
    }

    @Override
    public void addNamedSkip(KtGlue skip, String name) {
        this.addNode(new KtNamedHSkipNode(skip, name));
    }

    @Override
    public void addRule(KtBoxSizes sizes) {
        this.addNode(new KtRuleNode(sizes));
    }

    @Override
    public void addLeaders(KtGlue skip, KtLeaders lead) {
        this.addNode(new KtHLeadersNode(skip, lead));
    }

    @Override
    public void addLeadRule(KtGlue skip, KtBoxSizes sizes, String desc) {
        this.addNode(new KtHLeadRuleNode(skip, sizes, desc));
    }

    @Override
    public KtBoxLeaders.KtMover getBoxLeadMover() {
        return KtHLeadersNode.BOX_MOVER;
    }

    @Override
    public void addBox(KtNode box) {
        this.list.append(new KtOrdNoad(new KtNodeField(box)));
    }

    @Override
    public boolean canTakeLastBox() {
        return false;
    }

    private KtFractionNoad makeFraction(KtNoadList num, KtField den) {
        return this.fractLeft != KtDelimiter.NULL ? new KtDelFractionNoad(new KtNoadListField(num), den, this.thickness, this.fractLeft, this.fractRight) : new KtFractionNoad(new KtNoadListField(num), den, this.thickness);
    }

    public boolean alreadyFractioned() {
        return this.numerator != KtNoadList.NULL;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty() && !this.alreadyFractioned();
    }

    public void fractione(KtDimen thickness) {
        this.numerator = this.getList();
        this.list = new KtNoadList();
        this.thickness = thickness;
    }

    public void fractione(KtDimen thickness, KtDelimiter left, KtDelimiter right) {
        this.fractione(thickness);
        this.fractLeft = left;
        this.fractRight = right;
    }

    public KtNoadList getList() {
        return this.numerator == KtNoadList.NULL ? this.list : new KtNoadList(this.makeFraction(this.numerator, new KtNoadListField(this.list)));
    }

    @Override
    protected void specialShow(KtLog log, int depth, int breadth) {
        KtCntxLog.addItems(log, (this.alreadyFractioned() ? this.list : this.fakeLeftDelim(this.list)).noads(), depth, breadth);
        log.endLine();
        if (this.alreadyFractioned()) {
            log.add("this will be denominator of:");
            KtCntxLog.addItem(log, this.makeFraction(this.fakeLeftDelim(this.numerator), KtEmptyField.FIELD), depth, breadth);
        }
    }

    private KtNoadList fakeLeftDelim(KtNoadList list) {
        if (this.leftDelim == KtNoad.NULL) {
            return list;
        }
        KtNoadList faked = new KtNoadList(list.length() + 1);
        return faked.append(this.leftDelim).append(list);
    }

    public void setEqNo(KtNode node, boolean left) {
    }
}

