/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import java.io.Serializable;

public class KtGlueSetting
implements Serializable,
KtLoggable {
    public static final byte RIGID = 0;
    public static final byte STRETCHING = 1;
    public static final byte SHRINKING = 2;
    protected final byte sign;
    protected final byte order;
    protected final double ratio;
    public static final KtGlueSetting NATURAL = new KtGlueSetting(0, 0, 0.0);

    public KtGlueSetting(byte sign, byte order, double ratio) {
        this.sign = sign;
        this.order = order;
        this.ratio = ratio;
    }

    public KtDimen set(KtGlue glue, boolean limited) {
        KtDimen dimen = glue.getDimen();
        switch (this.sign) {
            case 1: {
                if (glue.getStrOrder() != this.order) break;
                dimen = limited ? dimen.plus(glue.getStretch().limitedTimes(this.ratio)) : dimen.plus(glue.getStretch().times(this.ratio));
                break;
            }
            case 2: {
                if (glue.getShrOrder() != this.order) break;
                dimen = limited ? dimen.minus(glue.getShrink().limitedTimes(this.ratio)) : dimen.minus(glue.getShrink().times(this.ratio));
            }
        }
        return dimen;
    }

    public boolean makesElastic(KtGlue glue) {
        return switch (this.sign) {
            case 1 -> {
                if (glue.getStrOrder() == this.order && !glue.getStretch().isZero()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (glue.getShrOrder() == this.order && !glue.getShrink().isZero()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public void addOn(KtLog log) {
        if (this.sign != 0 && this.ratio != 0.0) {
            log.add(", glue set ");
            if (this.sign == 2) {
                log.add("- ");
            }
            if (Math.abs(this.ratio) > 20000.0) {
                log.add(this.ratio > 0.0 ? ">" : "< -").add(KtGlue.toString(KtDimen.MAX_FROM_DOUBLE, this.order));
            } else {
                log.add(KtGlue.toString(KtDimen.valueOf(this.ratio), this.order));
            }
        }
    }
}

