/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import java.io.Serializable;

public class KtNetDimen
implements Serializable {
    public static final KtNetDimen NULL = null;
    private KtDimen natural;
    private KtDimen shrink;
    private final KtDimen[] stretch = new KtDimen[4];

    public KtDimen getNatural() {
        return this.natural;
    }

    public KtDimen getShrink() {
        return this.shrink;
    }

    public KtDimen getStretch(byte ord) {
        return this.stretch[ord];
    }

    public void setNatural(KtDimen dim) {
        this.natural = dim;
    }

    public void setShrink(KtDimen dim) {
        this.shrink = dim;
    }

    public void setStretch(KtDimen dim, byte ord) {
        this.stretch[ord] = dim;
    }

    public byte getMaxStrOrder() {
        byte ord;
        for (ord = 3; ord > 0 && this.stretch[ord].isZero(); ord = (byte)(ord - 1)) {
        }
        return ord;
    }

    public KtNetDimen() {
        this(KtDimen.ZERO);
    }

    public KtNetDimen(KtDimen d) {
        this.natural = d;
        this.shrink = KtDimen.ZERO;
        int i = 0;
        while (i < this.stretch.length) {
            this.stretch[i++] = KtDimen.ZERO;
        }
    }

    public KtNetDimen(KtGlue g) {
        this.natural = g.getDimen();
        this.shrink = g.getShrink();
        int i = 0;
        while (i < this.stretch.length) {
            this.stretch[i++] = KtDimen.ZERO;
        }
        this.stretch[g.getStrOrder()] = g.getStretch();
    }

    public KtNetDimen(KtNetDimen nd) {
        this.natural = nd.natural;
        this.shrink = nd.shrink;
        for (int i = 0; i < this.stretch.length; ++i) {
            this.stretch[i] = nd.stretch[i];
        }
    }

    public final void add(KtDimen d) {
        this.natural = this.natural.plus(d);
    }

    public final void addShrink(KtDimen d) {
        this.shrink = this.shrink.plus(d);
    }

    public final void addStretch(byte ord, KtDimen d) {
        this.stretch[ord] = this.stretch[ord].plus(d);
    }

    public void add(KtGlue g) {
        this.add(g.getDimen());
        this.addShrink(g.getShrink());
        this.addStretch(g.getStrOrder(), g.getStretch());
    }

    public void add(KtNetDimen nd) {
        this.add(nd.natural);
        this.addShrink(nd.shrink);
        for (byte o = 0; o < this.stretch.length; o = (byte)(o + 1)) {
            this.addStretch(o, nd.stretch[o]);
        }
    }

    public final void sub(KtDimen d) {
        this.natural = this.natural.minus(d);
    }

    public final void subShrink(KtDimen d) {
        this.shrink = this.shrink.minus(d);
    }

    public final void subStretch(byte ord, KtDimen d) {
        this.stretch[ord] = this.stretch[ord].minus(d);
    }

    public void sub(KtGlue g) {
        this.sub(g.getDimen());
        this.subShrink(g.getShrink());
        this.subStretch(g.getStrOrder(), g.getStretch());
    }

    public void sub(KtNetDimen nd) {
        this.sub(nd.natural);
        this.subShrink(nd.shrink);
        for (byte o = 0; o < this.stretch.length; o = (byte)(o + 1)) {
            this.subStretch(o, nd.stretch[o]);
        }
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String unit) {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.natural.toString());
        if (unit != null) {
            buf.append(unit);
        }
        for (byte o = 0; o < this.stretch.length; o = (byte)((byte)(o + 1))) {
            if (this.stretch[o].isZero()) continue;
            KtGlue.append(buf.append(" plus "), this.stretch[o], o, unit);
        }
        if (!this.shrink.isZero()) {
            KtGlue.append(buf.append(" minus "), this.shrink, (byte)0, unit);
        }
        return buf.toString();
    }
}

