/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtInsertNode;
import com.whitemagicsoftware.keentype.node.KtInsertion;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtVBoxNode;
import com.whitemagicsoftware.keentype.node.KtVertSplit;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public abstract class KtPageSplit
extends KtVertSplit {
    private boolean discarding;
    private boolean nullSpecs;
    private KtNode last;
    private final Map<Integer, KtInsRecord> insMap = new TreeMap<Integer, KtInsRecord>();
    private final KtNodeList maybeOver = new KtNodeList();
    public int insertPenalties;
    private KtDimen bestGoal;
    private final KtNodeList heldOver;

    public KtPageSplit() {
        this.restart();
        this.insertPenalties = 0;
        this.heldOver = new KtNodeList();
    }

    private void restart() {
        this.discarding = true;
        this.nullSpecs = true;
        this.last = KtNode.NULL;
        this.insMap.clear();
        this.maybeOver.clear();
    }

    protected void freezeSpecs() {
        if (this.nullSpecs) {
            this.initSpecs();
            this.nullSpecs = false;
        }
    }

    protected abstract void initSpecs();

    @Override
    public KtNode lastSpecialNode() {
        KtNode node = this.lastNode();
        return node != KtNode.NULL ? node : this.last;
    }

    public boolean canChangeDimens() {
        return !this.nullSpecs;
    }

    @Override
    protected boolean waitingForMore() {
        return true;
    }

    @Override
    protected void passWhilePrunning(KtNode node) {
        this.pass(node);
    }

    @Override
    protected void passWhileBreaking(KtNode node) {
        this.pass(node);
    }

    @Override
    protected int extraPenalty() {
        return this.insertPenalties;
    }

    protected abstract void setInsVBox(int var1, KtBox var2);

    protected abstract KtBox getInsVBox(int var1);

    protected abstract KtGlue getInsSkip(int var1);

    protected abstract KtDimen getInsSize(int var1);

    protected abstract int getInsFactor(int var1);

    protected abstract void traceSplitCost(int var1, KtDimen var2, KtDimen var3, int var4);

    protected abstract KtNode splitTopAdjustment(KtDimen var1, KtGlue var2);

    private void pass(KtNode node) {
        KtNode ktNode = this.last = node.discardable() ? node : KtNode.NULL;
        if (node.isInsertion()) {
            this.freezeSpecs();
            KtInsertion ins = node.getInsertion();
            Integer key = ins.num;
            KtInsRecord rec = this.insMap.get(key);
            if (rec == null) {
                rec = new KtInsRecord(ins.num);
                this.insMap.put(key, rec);
            }
            if (rec.isFull()) {
                this.maybeOver.append(node);
                this.insertPenalties += ins.floatCost.intVal();
            } else {
                rec.record(ins);
            }
        }
    }

    @Override
    protected void markBestPlace() {
        Iterator<KtInsRecord> iterator = this.insMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().markBest();
        }
        this.heldOver.append(this.maybeOver);
        this.maybeOver.clear();
        this.bestGoal = this.goal;
    }

    private boolean step() {
        if (this.discarding) {
            boolean pruned = this.pruneTop();
            if (!this.nullSpecs) {
                this.adjustDepth();
            }
            if (pruned) {
                this.freezeSpecs();
                this.discarding = false;
            } else {
                return false;
            }
        }
        return this.findBreak();
    }

    public void build() {
        while (this.step()) {
            KtNodeList list = this.split();
            if (this.insertsWanted()) {
                Iterator<KtInsRecord> iterator = this.insMap.values().iterator();
                while (iterator.hasNext()) {
                    iterator.next().finish();
                }
                this.insertPenalties = this.heldOver.length();
                list = this.withoutInserts(list);
            } else {
                this.insertPenalties = 0;
                this.heldOver.clear();
            }
            this.restart();
            if (!this.performOutput(list, this.bestGoal)) continue;
            return;
        }
    }

    protected abstract boolean insertsWanted();

    protected abstract boolean performOutput(KtNodeList var1, KtDimen var2);

    private KtNodeList withoutInserts(KtNodeList list) {
        KtNodeList result = new KtNodeList();
        KtNodeEnum nodes = list.nodes();
        while (nodes.hasMoreNodes()) {
            KtNode node = nodes.nextNode();
            if (node.isInsertion()) continue;
            result.append(node);
        }
        return result;
    }

    public void startNextPage(KtNodeEnum output) {
        this.setNullSpecs();
        KtNodeList contrib = new KtNodeList(this.data);
        this.data = new Vector();
        this.append(this.heldOver);
        this.heldOver.clear();
        this.append(output);
        this.append(contrib);
    }

    public void startNextPage() {
        this.startNextPage(EMPTY_ENUM);
    }

    protected void show(KtLog log, int depth, int breadth, boolean act) {
        KtNodeEnum nodes;
        if (act) {
            nodes = this.heldOver.nodes();
            if (nodes.hasMoreNodes()) {
                log.startLine().add("### current page:").add(" (held over for next output)");
                KtCntxLog.addItems(log, nodes, depth, breadth);
            }
        } else {
            nodes = this.currPageList();
            if (nodes.hasMoreNodes()) {
                log.startLine().add("### current page:");
                KtCntxLog.addItems(log, nodes, depth, breadth);
                if (!this.nullSpecs) {
                    log.startLine().add("total height ").add(this.soFar.toString());
                    log.startLine().add(" goal height ").add(this.goal.toString());
                    Iterator<KtInsRecord> iterator = this.insMap.values().iterator();
                    while (iterator.hasNext()) {
                        iterator.next().show(log);
                    }
                }
            }
        }
        if ((nodes = this.contribList()).hasMoreNodes()) {
            log.startLine().add("### recent contributions:");
            KtCntxLog.addItems(log, nodes, depth, breadth);
        }
    }

    public abstract void show(KtLog var1, int var2, int var3);

    private class KtInsRecord {
        private final int num;
        private KtDimen size;
        private boolean full = false;
        private final Vector<KtNodeList> data = new Vector();
        private int bestCount = 0;

        public KtInsRecord(int number) {
            this.num = number;
            KtBox box = KtPageSplit.this.getInsVBox(this.num);
            KtGlue skip = KtPageSplit.this.getInsSkip(this.num);
            this.size = box.getHeight().plus(box.getDepth());
            KtPageSplit.this.goal = KtPageSplit.this.goal.minus(this.insScale(this.size, this.num)).minus(skip.getDimen());
            KtPageSplit.this.soFar.add(skip.resizedCopy(KtDimen.ZERO));
        }

        public boolean isFull() {
            return this.full;
        }

        public void markBest() {
            this.bestCount = this.data.size();
        }

        public void record(KtInsertion ins) {
            KtDimen delta = KtPageSplit.this.goal.plus(KtPageSplit.this.soFar.getShrink()).minus(KtPageSplit.this.soFar.getNatural()).minus(KtPageSplit.this.depth);
            KtDimen scal = this.insScale(ins.size, this.num);
            if (!(scal.moreThan(0) && scal.moreThan(delta) || this.size.plus(ins.size).moreThan(KtPageSplit.this.getInsSize(this.num)))) {
                this.size = this.size.plus(ins.size);
                KtPageSplit.this.goal = KtPageSplit.this.goal.minus(scal);
                this.data.add(ins.list);
            } else {
                this.split(ins);
            }
        }

        private void split(KtInsertion ins) {
            KtDimen space;
            int fac = KtPageSplit.this.getInsFactor(this.num);
            if (fac <= 0) {
                space = KtDimen.MAX_VALUE;
            } else {
                space = KtPageSplit.this.goal.minus(KtPageSplit.this.soFar.getNatural()).minus(KtPageSplit.this.depth);
                if (fac != 1000) {
                    space = space.over(fac).times(1000);
                }
            }
            space = space.min(KtPageSplit.this.getInsSize(this.num).minus(this.size));
            KtInsertSplit splitter = new KtInsertSplit(ins.list.nodes(), ins.topSkip);
            KtNodeList head = splitter.makeSplitting(space, ins.maxDepth);
            KtDimen bestSize = splitter.getBestSize();
            KtNode breakNode = splitter.breakNode();
            int cost = breakNode == KtNode.NULL ? -10000 : (breakNode.isPenalty() ? breakNode.getPenalty().intVal() : 0);
            KtPageSplit.this.traceSplitCost(this.num, space, bestSize, cost);
            this.full = true;
            this.size = this.size.plus(bestSize);
            KtPageSplit.this.goal = KtPageSplit.this.goal.minus(this.insScale(bestSize, this.num));
            this.data.add(head);
            KtPageSplit.this.insertPenalties += cost;
            if (!splitter.isEmpty()) {
                splitter.pruneTop();
                KtNodeList tail = new KtNodeList(splitter.nodes());
                KtVBoxNode vbox = KtVBoxNode.packedOf(tail);
                KtPageSplit.this.maybeOver.append(new KtInsertNode(ins.makeCopy(tail, vbox.getHeight().plus(vbox.getDepth()))));
            }
        }

        public void finish() {
            if (!this.data.isEmpty()) {
                KtNodeList list = new KtNodeList();
                KtNodeEnum boxList = KtPageSplit.this.getInsVBox(this.num).getVertList();
                if (boxList != KtNodeEnum.NULL) {
                    list.append(boxList);
                }
                for (int i = 0; i < this.bestCount; ++i) {
                    list.append(this.data.get(i));
                }
                KtPageSplit.this.setInsVBox(this.num, KtVBoxNode.packedOf(list));
            }
        }

        private KtDimen insScale(KtDimen size, int num) {
            int fac = KtPageSplit.this.getInsFactor(num);
            return fac == 1000 ? size : size.over(1000).times(fac);
        }

        public void show(KtLog log) {
            log.endLine().addEsc("insert").add(this.num).add(" adds ").add(this.size.over(1000).times(KtPageSplit.this.getInsFactor(this.num)).toString());
            if (this.full) {
                log.add(", #").add(this.data.size()).add(" might split");
            }
        }
    }

    protected class KtInsertSplit
    extends KtVertSplit {
        private final KtGlue topSkip;
        private KtDimen bestSize;

        public KtInsertSplit(KtNodeEnum nodes, KtGlue topSkip) {
            super(nodes);
            this.topSkip = topSkip;
        }

        public KtDimen getBestSize() {
            return this.bestSize;
        }

        @Override
        protected void markBestPlace() {
            this.bestSize = this.soFar.getNatural().plus(this.depth);
        }

        @Override
        protected KtNode topAdjustment(KtDimen height) {
            return KtPageSplit.this.splitTopAdjustment(height, this.topSkip);
        }
    }
}

