/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tex;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.base.KtPairKey;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtFileName;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.io.KtName;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtTypesetter;
import com.whitemagicsoftware.keentype.tex.KtFontInfo;
import com.whitemagicsoftware.keentype.tex.KtFontInformator;
import com.whitemagicsoftware.keentype.tex.KtInfoTeXFontMetric;
import com.whitemagicsoftware.keentype.tex.KtTeXIOHandler;
import com.whitemagicsoftware.keentype.tfm.KtBadTeXFmException;
import com.whitemagicsoftware.keentype.tfm.KtTeXFm;
import com.whitemagicsoftware.keentype.tfm.KtTeXFontMetric;
import com.whitemagicsoftware.keentype.typo.KtNullFontMetric;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class KtTeXFontHandler
extends KtCommandBase
implements KtTypoCommand.KtTypoHandler,
KtFontInformator {
    protected static final KtTeXFmGroup NULL_GROUP;
    private KtTypesetter mTypesetter = KtTypesetter.NULL;
    private final KtConfig config;
    private final HashMap<String, KtTeXFmGroup> groupTab;
    private final KtSequencer sequencer;
    private final HashMap<KtFontMetric, KtNum> paramTab1 = new HashMap();
    private final HashMap<KtPairKey, KtDimen> paramTab2 = new HashMap();
    private static final int[] rTab;

    public KtTeXFontHandler(KtConfig config, Object seed) {
        assert (config != null);
        this.config = config;
        if (seed instanceof KtSeed) {
            KtSeed s = (KtSeed)seed;
            this.groupTab = s.groupTab;
            this.sequencer = s.sequencer;
        } else {
            this.groupTab = new HashMap();
            this.sequencer = new KtSequencer();
        }
    }

    public KtTeXFontHandler(KtConfig config) {
        this(config, null);
    }

    public Object getSeed() {
        return new KtSeed(this.groupTab, this.sequencer);
    }

    @Override
    public KtFontMetric getMetric(KtFileName name, KtDimen size, KtNum scale, KtName ident, KtLoggable tok) {
        String path = name.getPath();
        KtTeXFmGroup group = this.groupTab.get(path);
        if (group == NULL_GROUP) {
            KtTeXFm tfm;
            KtName groupName = name.baseName();
            try {
                tfm = KtTeXFm.readFrom(KtTeXIOHandler.openTeXFm(name));
            }
            catch (FileNotFoundException e) {
                this.fontError("TFMnotFound", path, size, scale, tok);
                return KtFontMetric.NULL;
            }
            catch (KtBadTeXFmException e) {
                this.fontError("TFMisBad", path, size, scale, tok);
                return KtFontMetric.NULL;
            }
            catch (IOException e) {
                System.err.println(String.valueOf(e) + "when reading " + String.valueOf(name));
                return KtFontMetric.NULL;
            }
            group = new KtTeXFmGroup(groupName, tfm, path);
            this.groupTab.put(path, group);
        }
        return group.get(size, scale, ident, this.config, this.sequencer);
    }

    private void fontError(String err, String path, KtDimen size, KtNum scale, KtLoggable tok) {
        KtTeXFontHandler.error(err, log -> {
            log.add(tok).add('=').add(path);
            if (size != KtDimen.NULL) {
                log.add(" at " + String.valueOf(size) + "pt");
            }
            if (scale != KtNum.NULL) {
                log.add(" scaled " + String.valueOf(scale));
            }
        });
    }

    @Override
    public KtTypoCommand.KtFontDimen getFontDimen(KtFontMetric metric, int num) {
        int idx = num - 1;
        int maxDefined = -1;
        if (KtTeXFontHandler.validRawDimIdx(idx)) {
            if (this.getRawDimPar(metric, idx) != KtDimen.NULL) {
                return this.makeFontDimen(metric, idx);
            }
            if (metric == this.sequencer.lastLoaded) {
                this.defineRawDimParsUpTo(metric, idx);
                return this.makeFontDimen(metric, idx);
            }
        } else {
            KtNum max = this.paramTab1.get(metric);
            if (max != KtNum.NULL) {
                maxDefined = max.intVal();
            }
            if (idx > maxDefined && metric == this.sequencer.lastLoaded) {
                this.defineRawDimParsUpTo(metric, idx);
                maxDefined = idx;
                this.paramTab1.put(metric, KtNum.valueOf(maxDefined));
            }
            if (0 <= idx && idx <= maxDefined) {
                return this.makeFontDimen(new KtPairKey(metric, KtNum.valueOf(idx)));
            }
        }
        if (maxDefined < 0) {
            maxDefined = this.maxDefinedRawDimPar(metric);
        }
        KtTeXFontHandler.error("TooBigFontdimenNum", KtTeXFontHandler.esc(metric.getIdent()), KtTeXFontHandler.num(maxDefined + 1));
        return new KtTypoCommand.KtFontDimen(this){

            @Override
            public KtDimen get() {
                return KtDimen.ZERO;
            }

            @Override
            public void set(KtDimen dim) {
            }
        };
    }

    private KtTypoCommand.KtFontDimen makeFontDimen(final KtFontMetric metric, final int idx) {
        return new KtTypoCommand.KtFontDimen(){
            final /* synthetic */ KtTeXFontHandler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public KtDimen get() {
                return this.this$0.getRawDimPar(metric, idx);
            }

            @Override
            public void set(KtDimen dim) {
                this.this$0.setRawDimPar(metric, idx, dim);
            }
        };
    }

    private KtTypoCommand.KtFontDimen makeFontDimen(final KtPairKey key) {
        return new KtTypoCommand.KtFontDimen(){
            final /* synthetic */ KtTeXFontHandler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public KtDimen get() {
                KtDimen dim = this.this$0.paramTab2.get(key);
                return dim != KtDimen.NULL ? dim : KtDimen.ZERO;
            }

            @Override
            public void set(KtDimen dim) {
                this.this$0.paramTab2.put(key, dim);
            }
        };
    }

    private static boolean validRawDimIdx(int idx) {
        return 0 <= idx && idx < rTab.length && rTab[idx] >= 0;
    }

    private KtDimen getRawDimPar(KtFontMetric metric, int idx) {
        return metric.getDimenParam(rTab[idx]);
    }

    private void setRawDimPar(KtFontMetric metric, int idx, KtDimen val) {
        int lTab = KtTeXFontMetric.numberOfRawDimenPars();
        for (int i = 0; i < lTab; ++i) {
            if (KtTeXFontMetric.rawDimenParNumber(i) != idx) continue;
            metric.setDimenParam(i, val);
        }
    }

    private int maxDefinedRawDimPar(KtFontMetric metric) {
        int i = rTab.length;
        while (--i >= 0) {
            if (rTab[i] < 0 || metric.getDimenParam(rTab[i]) == KtDimen.NULL) continue;
            return i;
        }
        return -1;
    }

    private void defineRawDimParsUpTo(KtFontMetric metric, int idx) {
        int lTab = KtTeXFontMetric.numberOfRawDimenPars();
        for (int i = 0; i < lTab; ++i) {
            if (KtTeXFontMetric.rawDimenParNumber(i) > idx || metric.getDimenParam(i) != KtDimen.NULL) continue;
            metric.setDimenParam(i, KtDimen.ZERO);
        }
    }

    @Override
    public KtTypesetter getTypesetter() {
        return this.mTypesetter;
    }

    @Override
    public void setTypesetter(KtTypesetter typeSetter) {
        this.mTypesetter = typeSetter;
    }

    @Override
    public KtFontInfo getInfo(KtFontMetric metric) {
        if (metric instanceof KtInfoTeXFontMetric) {
            return (KtInfoTeXFontMetric)metric;
        }
        throw new RuntimeException("No info about a font metric");
    }

    static {
        int i;
        NULL_GROUP = null;
        int lTab = KtTeXFontMetric.numberOfRawDimenPars();
        int mTab = -1;
        for (i = 0; i < lTab; ++i) {
            if (mTab >= KtTeXFontMetric.rawDimenParNumber(i)) continue;
            mTab = KtTeXFontMetric.rawDimenParNumber(i);
        }
        rTab = new int[mTab + 1];
        i = 0;
        while (i < rTab.length) {
            KtTeXFontHandler.rTab[i++] = -1;
        }
        for (i = 0; i < lTab; ++i) {
            int j = KtTeXFontMetric.rawDimenParNumber(i);
            if (j < 0) continue;
            KtTeXFontHandler.rTab[j] = i;
        }
    }

    public static interface KtConfig {
        public KtNum defaultHyphenChar();

        public KtNum defaultSkewChar();
    }

    private static class KtSeed
    implements Serializable {
        public final HashMap<String, KtTeXFmGroup> groupTab;
        public final KtSequencer sequencer;

        public KtSeed(HashMap<String, KtTeXFmGroup> tab, KtSequencer seq) {
            this.groupTab = tab;
            this.sequencer = seq;
        }
    }

    private static final class KtSequencer
    implements Serializable {
        public int nextIdNum = 0;
        public KtFontMetric lastLoaded = KtNullFontMetric.METRIC;

        private KtSequencer() {
        }
    }

    protected static class KtTeXFmGroup
    implements Serializable {
        private final KtName name;
        private final KtTeXFm tfm;
        private final byte[] dirName;
        private final byte[] fileName;
        private final Vector<KtTeXFontMetric> members = new Vector();

        public KtTeXFmGroup(KtName name, KtTeXFm tfm, String path) {
            this.name = name;
            this.tfm = tfm;
            String fname = new File(path).getName();
            int i = path.lastIndexOf(fname);
            this.dirName = i > 0 ? path.substring(0, i).getBytes() : new byte[]{};
            i = fname.length();
            while (--i > 0 && fname.charAt(i) != '.') {
            }
            this.fileName = (i > 0 ? fname.substring(0, i) : fname).getBytes();
        }

        public KtName getName() {
            return this.name;
        }

        public KtTeXFm getTfm() {
            return this.tfm;
        }

        public KtFontMetric get(KtDimen size, KtNum scale, KtName ident, KtConfig config, KtSequencer seq) {
            KtTeXFontMetric metric;
            if (size == KtDimen.NULL) {
                size = KtDimen.valueOf(this.tfm.getDesignSize());
            }
            if (scale != KtNum.NULL) {
                size = size.times(scale.intVal(), 1000);
            }
            for (int i = 0; i < this.members.size(); ++i) {
                metric = this.members.elementAt(i);
                if (!size.equals(metric.getAtSize())) continue;
                metric.setIdent(ident);
                return metric;
            }
            metric = new KtInfoTeXFontMetric(this.name, this.tfm, size, ident, seq.nextIdNum++, this.dirName, this.fileName);
            metric.setNumParam(0, config.defaultHyphenChar());
            metric.setNumParam(1, config.defaultSkewChar());
            this.members.addElement(metric);
            seq.lastLoaded = metric;
            return metric;
        }
    }
}

