/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.builder.KtNullBuilder;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtFrozenToken;
import com.whitemagicsoftware.keentype.command.KtLeftBraceToken;
import com.whitemagicsoftware.keentype.command.KtMacro;
import com.whitemagicsoftware.keentype.command.KtMacroBody;
import com.whitemagicsoftware.keentype.command.KtPrim;
import com.whitemagicsoftware.keentype.command.KtRightBraceToken;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtBaseNode;
import com.whitemagicsoftware.keentype.node.KtSettingContext;
import com.whitemagicsoftware.keentype.node.KtTypesetter;
import com.whitemagicsoftware.keentype.typo.KtBuilderPrim;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;

public class KtWritePrim
extends KtBuilderPrim {
    private transient HashMap<Integer, KtLog> table;
    private static final KtToken FROZEN_END_WRITE = new KtFrozenToken("endwrite", (KtCommand)new KtMacro(KtMacroBody.EMPTY, 2));
    private static final KtToken[] END_TOKS = new KtToken[]{KtRightBraceToken.TOKEN, FROZEN_END_WRITE};
    private static final KtTokenList END_LIST = new KtTokenList(END_TOKS);
    private static final KtNullBuilder NULL_BUILDER = new KtNullBuilder();

    private void initTable() {
        this.table = new HashMap(23);
    }

    public KtWritePrim(String name) {
        super(name);
        this.initTable();
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.initTable();
    }

    public KtLog get(int num) {
        return this.table.get(num);
    }

    private KtLog replace(int num, KtLog output) {
        return this.table.put(num, output);
    }

    public void set(int num, KtLog output) {
        KtLog old = this.replace(num, output);
        if (old != output && old != KtLog.NULL) {
            old.close();
        }
    }

    @Override
    public void exec(KtBuilder bld, KtToken src) {
        int num = KtWritePrim.scanInt();
        KtTokenList list = KtPrim.scanTokenList(src, false);
        bld.addNode(new KtWriteNode(num, list));
    }

    @Override
    public boolean immedExec(KtToken src) {
        int num = KtWritePrim.scanInt();
        KtTokenList list = KtPrim.scanTokenList(src, false);
        this.write(num, list);
        return true;
    }

    protected void write(int num, KtTokenList list) {
        KtLog output;
        KtWritePrim.insertList(END_LIST);
        KtWritePrim.tracedPushXList(list, "write");
        KtWritePrim.insertTokenWithoutCleaning(KtLeftBraceToken.TOKEN);
        KtBuilder.push(NULL_BUILDER);
        list = KtPrim.scanTokenList(this, true);
        KtToken tok = KtWritePrim.nextRawToken();
        if (tok != FROZEN_END_WRITE) {
            KtWritePrim.error("UnbalancedWrite");
            while ((tok = KtWritePrim.nextRawToken()) != FROZEN_END_WRITE) {
            }
        }
        KtBuilder.pop();
        KtWritePrim.getTokStack().dropFinishedPop();
        if (num < 0) {
            output = fileLog.startLine();
        } else {
            output = this.get(num);
            if (output == KtLog.NULL) {
                output = normLog.startLine();
            }
        }
        output.add(list).endLine();
    }

    protected class KtWriteNode
    extends KtFileNode {
        protected KtTokenList list;

        public KtWriteNode(int num, KtTokenList list) {
            super(num);
            this.list = list;
        }

        @Override
        public void addOn(KtLog log, KtCntxLog cntx) {
            KtBuilderPrim.addNodeToks(this.addName(log, "write"), this.list);
        }

        @Override
        public void typeSet(KtTypesetter setter, KtSettingContext sctx) {
            if (sctx.allowIO) {
                KtWritePrim.this.write(this.num, this.list);
            }
        }
    }

    protected static abstract class KtFileNode
    extends KtBaseNode {
        protected int num;

        public KtFileNode(int num) {
            this.num = num;
        }

        @Override
        public boolean sizeIgnored() {
            return true;
        }

        protected KtLog addName(KtLog log, String name) {
            log.addEsc(name);
            return this.num < 0 ? log.add('-') : (this.num > KtCommandBase.getConfig().getIntParam(KtPrim.INTP_MAX_FILE_CODE) ? log.add('*') : log.add(this.num));
        }

        @Override
        public byte beforeWord() {
            return 1;
        }

        @Override
        public byte afterWord() {
            return 2;
        }
    }
}

