/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.command.KtCharToken;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;

public class KtSpaceToken
extends KtToken {
    public static final KtCharCode CODE = KtCharToken.makeCharCode(' ');
    public static final KtSpaceToken TOKEN = new KtSpaceToken();
    private static KtToken.KtCharHandler handler;
    public static final String DESCRIPTION = "blank space";
    public static final KtCommand MEANING;

    @Override
    public KtCharCode nonActiveCharCode() {
        return CODE;
    }

    @Override
    public int numValue() {
        return CODE.numValue();
    }

    @Override
    public KtCharCode charCode() {
        return CODE;
    }

    @Override
    public KtToken makeCharToken(KtCharCode code) {
        return KtDirtySpaceToken.MAKER.make(code);
    }

    @Override
    public boolean matchSpace() {
        return true;
    }

    @Override
    public boolean match(KtToken tok) {
        return tok instanceof KtSpaceToken;
    }

    @Override
    public boolean sameCatAs(KtToken tok) {
        return tok instanceof KtSpaceToken || tok instanceof KtDirtySpaceToken;
    }

    @Override
    public void addOn(KtLog log) {
        log.add(' ');
    }

    public String toString() {
        return "<Space>";
    }

    public static void setHandler(KtToken.KtCharHandler hnd) {
        handler = hnd;
        KtDirtySpaceToken.setHandler(hnd);
    }

    @Override
    public KtCommand meaning() {
        return MEANING;
    }

    static {
        MEANING = new KtCommand(){

            @Override
            public boolean isSpacer() {
                return true;
            }

            @Override
            public KtCharCode charCode() {
                return CODE;
            }

            @Override
            public void exec(KtToken src) {
                handler.handle(CODE, src);
            }

            @Override
            public void exec(KtToken src, int prefixes) {
                KtToken tok = 1.nextExpToken();
                1.meaningOf(tok).execute(tok, prefixes);
            }

            @Override
            public void addOn(KtLog log) {
                log.add(KtSpaceToken.DESCRIPTION).add(' ').add(' ');
            }

            @Override
            public boolean sameAs(KtCommand cmd) {
                return this.getClass() == cmd.getClass();
            }

            @Override
            public KtToken origin() {
                return TOKEN;
            }
        };
    }

    static class KtDirtySpaceToken
    extends KtCharToken {
        public static final KtCharToken.KtMaker MAKER = new KtCharToken.KtMaker(){

            @Override
            public KtToken make(KtCharCode code) {
                if (code.match(' ')) {
                    return TOKEN;
                }
                return new KtDirtySpaceToken(code);
            }
        };
        private static KtToken.KtCharHandler handler;

        public KtDirtySpaceToken(KtCharCode code) {
            super(code);
        }

        @Override
        public boolean match(KtCharToken tok) {
            return tok instanceof KtDirtySpaceToken && tok.match(this.code);
        }

        @Override
        public boolean sameCatAs(KtToken tok) {
            return TOKEN.sameCatAs(tok);
        }

        @Override
        public KtCharToken.KtMaker getMaker() {
            return MAKER;
        }

        @Override
        public String toString() {
            return "<DirtySpace: " + String.valueOf(this.code) + ">";
        }

        public static void setHandler(KtToken.KtCharHandler hnd) {
            handler = hnd;
        }

        @Override
        public KtCommand meaning() {
            return new KtCharToken.KtMeaning(){

                @Override
                public void exec(KtToken src) {
                    handler.handle(code, src);
                }

                @Override
                public void exec(KtToken src, int prefixes) {
                    KtToken tok = 2.nextExpToken();
                    2.meaningOf(tok).execute(tok, prefixes);
                }

                @Override
                protected String description() {
                    return KtSpaceToken.DESCRIPTION;
                }
            };
        }
    }
}

