/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tfm;

import com.whitemagicsoftware.keentype.base.KtBoolPar;
import com.whitemagicsoftware.keentype.base.KtIntPar;
import com.whitemagicsoftware.keentype.tfm.KtFixWord;
import com.whitemagicsoftware.keentype.tfm.KtIndexMultimap;
import com.whitemagicsoftware.keentype.tfm.KtPLDumper;
import com.whitemagicsoftware.keentype.tfm.KtTeXFmDiagnostic;
import com.whitemagicsoftware.keentype.tfm.KtTeXFmLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class KtTeXFm
implements Serializable {
    public static final short NO_CHAR_CODE = -1;
    public static final int NO_INDEX = -1;
    protected int checkSum;
    protected KtFixWord designSize;
    protected short firstCharCode;
    protected KtCharInfo[] charTable;
    protected short boundaryChar = (short)-1;
    protected int boundaryStart = -1;
    protected KtLigKern[] ligKernTable;
    protected KtFixWord[] paramTable;
    protected String codingScheme;
    protected String family;
    protected int face;
    protected boolean sevenBitSafe;
    protected int[] headerRest;
    protected int restIndex;
    protected static final int BOUNDARY_LABEL_CODE = -1;
    private static int init_fp = 0;
    public static final int FP_SLANT = init_fp++;
    public static final int FP_SPACE = init_fp++;
    public static final int FP_STRETCH = init_fp++;
    public static final int FP_SHRINK = init_fp++;
    public static final int FP_X_HEIGHT = init_fp++;
    public static final int FP_QUAD = init_fp++;
    public static final int FP_EXTRA_SPACE = init_fp++;
    public static final int FP_MAX = init_fp++;
    protected static final String[] paramLabel = new String[]{"SLANT", "SPACE", "STRETCH", "SHRINK", "XHEIGHT", "QUAD", "EXTRASPACE"};

    protected KtTeXFm(int checkSum, KtFixWord designSize, short firstCharCode, KtCharInfo[] charTable, short boundaryChar, int boundaryStart, KtLigKern[] ligKernTable, KtFixWord[] paramTable, String codingScheme, String family, int face, boolean sevenBitSafe, int[] headerRest, int restIndex) {
        this.checkSum = checkSum;
        this.designSize = designSize;
        this.firstCharCode = firstCharCode;
        this.charTable = charTable;
        this.boundaryChar = boundaryChar;
        this.boundaryStart = boundaryStart;
        this.ligKernTable = ligKernTable;
        this.paramTable = paramTable;
        this.codingScheme = codingScheme;
        this.family = family;
        this.face = face;
        this.sevenBitSafe = sevenBitSafe;
        this.headerRest = headerRest;
        this.restIndex = restIndex;
    }

    public static KtTeXFm readFrom(InputStream in, KtTeXFmDiagnostic dg) throws IOException {
        return new KtTeXFmLoader(in, dg).getMetric();
    }

    public static KtTeXFm readFrom(InputStream in) throws IOException {
        return new KtTeXFmLoader(in).getMetric();
    }

    public static KtTeXFm readFrom(String path, KtTeXFmDiagnostic dg) throws IOException {
        return new KtTeXFmLoader(path, dg).getMetric();
    }

    public static KtTeXFm readFrom(String path) throws IOException {
        return new KtTeXFmLoader(path).getMetric();
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public KtFixWord getDesignSize() {
        return this.designSize;
    }

    public int paramCount() {
        return this.paramTable.length;
    }

    public KtFixWord getParam(int idx) {
        return this.paramTable[idx];
    }

    public KtCharInfo getCharInfo(short idx) {
        return 0 <= (idx = (short)(idx - this.firstCharCode)) && idx < this.charTable.length ? this.charTable[idx] : KtCharInfo.NULL;
    }

    public KtLigKern getLigKern(short left, short right) {
        int i;
        if (left == -1) {
            i = this.boundaryStart;
        } else {
            KtCharInfo info = this.getCharInfo(left);
            int n = i = info != KtCharInfo.NULL ? info.ligKernStart() : -1;
        }
        if (right == -1) {
            right = this.boundaryChar;
        }
        if (right != -1) {
            while (i != -1) {
                KtLigKern lk = this.ligKernTable[i];
                if (lk.nextChar == right) {
                    return lk;
                }
                i = lk.nextIndex(i);
            }
        }
        return KtLigKern.NULL;
    }

    public KtPLDumper dump(KtPLDumper dmp) {
        if (this.family != null) {
            dmp.open("FAMILY").addStr(this.family).close();
        }
        if (this.face >= 0) {
            dmp.open("FACE").addFace(this.face).close();
        }
        if (this.headerRest != null) {
            KtTeXFm.dumpHeaderRest(dmp, this.headerRest, this.restIndex);
        }
        if (this.codingScheme != null) {
            dmp.open("CODINGSCHEME").addStr(this.codingScheme).close();
        }
        dmp.open("DESIGNSIZE").addReal(this.designSize).close();
        this.dumpComment(dmp, "DESIGNSIZE IS IN POINTS");
        this.dumpComment(dmp, "OTHER SIZES ARE MULTIPLES OF DESIGNSIZE");
        dmp.open("CHECKSUM").addOct(this.checkSum).close();
        if (this.sevenBitSafe) {
            dmp.open("SEVENBITSAFEFLAG").addBool(this.sevenBitSafe).close();
        }
        this.dumpParams(dmp);
        this.dumpLigKernTable(dmp);
        this.dumpChars(dmp);
        return dmp;
    }

    protected KtPLDumper dumpParams(KtPLDumper dmp) {
        if (this.paramTable.length > 0) {
            dmp.open("FONTDIMEN");
            for (int i = 0; i < this.paramTable.length; ++i) {
                String name = this.paramName(i);
                if (name != null) {
                    dmp.open(name);
                } else {
                    dmp.open("PARAMETER").addDec(i + 1);
                }
                dmp.addReal(this.paramTable[i]).close();
            }
            dmp.close();
        }
        return dmp;
    }

    protected void dumpLigKernTable(KtPLDumper dmp) {
        if (this.boundaryChar != -1) {
            dmp.open("BOUNDARYCHAR").addChar(this.boundaryChar).close();
        }
        if (this.ligKernTable.length > 0) {
            dmp.open("LIGTABLE");
            boolean[] activity = new boolean[this.ligKernTable.length];
            KtIndexMultimap labels = this.buildLabels(activity);
            this.computeActivity(activity);
            boolean commenting = false;
            for (int i = 0; i < this.ligKernTable.length; ++i) {
                if (activity[i]) {
                    if (commenting) {
                        dmp.close();
                        commenting = false;
                    }
                    KtIndexMultimap.KtEnum lab = labels.forKey(i);
                    while (lab.hasMore()) {
                        short charCode = (short)lab.next();
                        dmp.open("LABEL");
                        if (charCode == -1) {
                            dmp.addStr("BOUNDARYCHAR");
                        } else {
                            dmp.addChar(charCode);
                        }
                        dmp.close();
                    }
                    this.ligKernTable[i].dump(dmp, activity, i);
                    continue;
                }
                if (!commenting) {
                    dmp.open("COMMENT");
                    dmp.addStr("THIS PART OF THE PROGRAM IS NEVER USED!");
                    commenting = true;
                }
                this.ligKernTable[i].dump(dmp);
            }
            if (commenting) {
                dmp.close();
            }
            dmp.close();
        }
    }

    protected KtIndexMultimap buildLabels(boolean[] active) {
        KtIndexMultimap labels = new KtIndexMultimap();
        if (this.boundaryStart != -1) {
            labels.add(this.boundaryStart, -1);
            active[this.boundaryStart] = true;
        }
        for (int i = 0; i < this.charTable.length; ++i) {
            int start;
            if (this.charTable[i] == KtCharInfo.NULL || (start = this.charTable[i].ligKernStart()) == -1) continue;
            labels.add(start, i + this.firstCharCode);
            active[start] = true;
        }
        return labels;
    }

    protected void computeActivity(boolean[] active) {
        for (int i = 0; i < this.ligKernTable.length; ++i) {
            int next;
            if (!active[i] || (next = this.ligKernTable[i].nextIndex(i)) == -1) continue;
            active[next] = true;
        }
    }

    protected void dumpChars(KtPLDumper dmp) {
        for (int i = 0; i < this.charTable.length; ++i) {
            if (this.charTable[i] == KtCharInfo.NULL) continue;
            dmp.open("CHARACTER").addChar((short)(i + this.firstCharCode));
            this.charTable[i].dump(dmp, this).close();
        }
    }

    protected static void dumpHeaderRest(KtPLDumper dmp, int[] rest, int num) {
        for (int i = 0; i < rest.length; ++i) {
            dmp.open("HEADER").addDec(i + num).addOct(rest[i]).close();
        }
    }

    protected KtPLDumper dumpComment(KtPLDumper dmp, String s) {
        return dmp.open("COMMENT").addStr(s).close();
    }

    protected String paramName(int i) {
        return i < paramLabel.length ? paramLabel[i] : null;
    }

    public static class KtCharInfo
    implements Serializable {
        public static final KtCharInfo NULL = null;
        private final KtFixWord width;
        private final KtFixWord height;
        private final KtFixWord depth;
        private final KtFixWord italic;

        public KtCharInfo(KtFixWord w, KtFixWord h, KtFixWord d, KtFixWord i) {
            this.width = w;
            this.height = h;
            this.depth = d;
            this.italic = i;
        }

        public final KtFixWord getWidth() {
            return this.width;
        }

        public final KtFixWord getHeight() {
            return this.height;
        }

        public final KtFixWord getDepth() {
            return this.depth;
        }

        public final KtFixWord getItalic() {
            return this.italic;
        }

        public int ligKernStart() {
            return -1;
        }

        public short nextChar() {
            return -1;
        }

        public short extTop() {
            return -1;
        }

        public short extMid() {
            return -1;
        }

        public short extBot() {
            return -1;
        }

        public short extRep() {
            return -1;
        }

        public KtPLDumper dump(KtPLDumper dmp, KtTeXFm tfm) {
            this.dumpDimen(dmp, this.width, "CHARWD");
            this.dumpDimen(dmp, this.height, "CHARHT");
            this.dumpDimen(dmp, this.depth, "CHARDP");
            this.dumpDimen(dmp, this.italic, "CHARIC");
            return dmp;
        }

        protected void dumpDimen(KtPLDumper dmp, KtFixWord dim, String what) {
            if (dim != KtFixWord.ZERO) {
                dmp.open(what).addReal(dim).close();
            }
        }
    }

    public static abstract class KtLigKern
    implements Serializable {
        public static final KtLigKern NULL = null;
        private final int skip;
        protected short nextChar;

        public KtLigKern(int skip, short next) {
            this.skip = skip;
            this.nextChar = next;
        }

        public short getLig(KtBoolPar left, KtBoolPar right, KtIntPar over) {
            return -1;
        }

        public KtFixWord getKern() {
            return KtFixWord.NULL;
        }

        public int nextIndex(int pos) {
            return this.skip < 0 ? -1 : pos + this.skip + 1;
        }

        public abstract KtPLDumper dump(KtPLDumper var1);

        public void dump(KtPLDumper dmp, boolean[] active, int pos) {
            this.dump(dmp);
            if (this.skip > 0) {
                int count = 0;
                int next = pos + this.skip + 1;
                while (++pos < next) {
                    if (!active[pos]) continue;
                    ++count;
                }
                dmp.open("SKIP").addDec(count).close();
            } else if (this.skip < 0) {
                dmp.open("STOP").close();
            }
        }
    }

    public static class KtExtCharInfo
    extends KtCharInfo {
        private final short top;
        private final short mid;
        private final short bot;
        private final short rep;

        public KtExtCharInfo(KtFixWord w, KtFixWord h, KtFixWord d, KtFixWord i, short t, short m, short b, short r) {
            super(w, h, d, i);
            this.top = t;
            this.mid = m;
            this.bot = b;
            this.rep = r;
        }

        @Override
        public final short extTop() {
            return this.top;
        }

        @Override
        public final short extMid() {
            return this.mid;
        }

        @Override
        public final short extBot() {
            return this.bot;
        }

        @Override
        public final short extRep() {
            return this.rep;
        }

        @Override
        public KtPLDumper dump(KtPLDumper dmp, KtTeXFm tfm) {
            super.dump(dmp, tfm);
            dmp.open("VARCHAR");
            this.dumpPart(dmp, this.top, "TOP");
            this.dumpPart(dmp, this.mid, "MID");
            this.dumpPart(dmp, this.bot, "BOT");
            this.dumpPart(dmp, this.rep, "REP");
            return dmp.close();
        }

        protected void dumpPart(KtPLDumper dmp, short c, String what) {
            if (c != -1) {
                dmp.open(what).addChar(c).close();
            }
        }
    }

    public static class KtListCharInfo
    extends KtCharInfo {
        private final short next;

        public KtListCharInfo(KtFixWord w, KtFixWord h, KtFixWord d, KtFixWord i, short n) {
            super(w, h, d, i);
            this.next = n;
        }

        @Override
        public final short nextChar() {
            return this.next;
        }

        @Override
        public KtPLDumper dump(KtPLDumper dmp, KtTeXFm tfm) {
            super.dump(dmp, tfm);
            return dmp.open("NEXTLARGER").addChar(this.next).close();
        }
    }

    public static class KtLigCharInfo
    extends KtCharInfo {
        private final int start;

        public KtLigCharInfo(KtFixWord w, KtFixWord h, KtFixWord d, KtFixWord i, int s) {
            super(w, h, d, i);
            this.start = s;
        }

        @Override
        public final int ligKernStart() {
            return this.start;
        }

        @Override
        public KtPLDumper dump(KtPLDumper dmp, KtTeXFm tfm) {
            super.dump(dmp, tfm);
            dmp.open("COMMENT");
            int i = this.start;
            while (i != -1) {
                tfm.ligKernTable[i].dump(dmp);
                i = tfm.ligKernTable[i].nextIndex(i);
            }
            return dmp.close();
        }
    }

    public static class KtKerning
    extends KtLigKern {
        private final KtFixWord kern;

        public KtKerning(int skip, short next, KtFixWord k) {
            super(skip, next);
            this.kern = k;
        }

        @Override
        public KtFixWord getKern() {
            return this.kern;
        }

        @Override
        public KtPLDumper dump(KtPLDumper dmp) {
            dmp.open("KRN").addChar(this.nextChar);
            return dmp.addReal(this.kern).close();
        }
    }

    public static class KtLigature
    extends KtLigKern {
        private final short addingChar;
        private final boolean keepLeft;
        private final boolean keepRight;
        private final byte stepOver;

        public KtLigature(int skip, short next, short a, boolean l, boolean r, byte s) {
            super(skip, next);
            this.addingChar = a;
            this.keepLeft = l;
            this.keepRight = r;
            this.stepOver = s;
        }

        @Override
        public short getLig(KtBoolPar left, KtBoolPar right, KtIntPar over) {
            left.set(this.keepLeft);
            right.set(this.keepRight);
            over.set(this.stepOver);
            return this.addingChar;
        }

        @Override
        public KtPLDumper dump(KtPLDumper dmp) {
            StringBuilder buf = new StringBuilder(7);
            if (this.keepLeft) {
                buf.append('/');
            }
            buf.append("LIG");
            if (this.keepRight) {
                buf.append('/');
            }
            byte i = this.stepOver;
            while (true) {
                byte by = i;
                i = (byte)(i - 1);
                if (by <= 0) break;
                buf.append('>');
            }
            dmp.open(buf.toString()).addChar(this.nextChar);
            return dmp.addChar(this.addingChar).close();
        }
    }
}

