/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.pqc.crypto.sphincsplus;

import net.jsign.bouncycastle.pqc.crypto.sphincsplus.PK;
import net.jsign.bouncycastle.pqc.crypto.sphincsplus.SK;
import net.jsign.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusKeyParameters;
import net.jsign.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusParameters;
import net.jsign.bouncycastle.util.Arrays;
import net.jsign.bouncycastle.util.Pack;

public class SPHINCSPlusPrivateKeyParameters
extends SPHINCSPlusKeyParameters {
    final SK sk;
    final PK pk;

    public SPHINCSPlusPrivateKeyParameters(SPHINCSPlusParameters sPHINCSPlusParameters, byte[] byArray) {
        super(true, sPHINCSPlusParameters);
        int n = sPHINCSPlusParameters.getN();
        if (byArray.length != 4 * n) {
            throw new IllegalArgumentException("private key encoding does not match parameters");
        }
        this.sk = new SK(Arrays.copyOfRange(byArray, 0, n), Arrays.copyOfRange(byArray, n, 2 * n));
        this.pk = new PK(Arrays.copyOfRange(byArray, 2 * n, 3 * n), Arrays.copyOfRange(byArray, 3 * n, 4 * n));
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(Pack.intToBigEndian(SPHINCSPlusParameters.getID(this.getParameters())), Arrays.concatenate(this.sk.seed, this.sk.prf, this.pk.seed, this.pk.root));
    }

    public byte[] getEncodedPublicKey() {
        return Arrays.concatenate(Pack.intToBigEndian(SPHINCSPlusParameters.getID(this.getParameters())), this.pk.seed, this.pk.root);
    }
}

