/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.app;

import com.whitemagicsoftware.keenquotes.app.KeenQuotes;
import com.whitemagicsoftware.keenquotes.parser.Apostrophe;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="KeenQuotes", mixinStandardHelpOptions=true, description={"Converts straight quotes to curly quotes."})
public final class Settings
implements Callable<Integer> {
    private final KeenQuotes mMain;
    @CommandLine.Option(names={"-ub", "--unamb-began"}, description={"Contraction to treat as unambiguous (e.g., cause, bout)"}, paramLabel="word")
    private String[] mBeganUnambiguous;
    @CommandLine.Option(names={"-ue", "--unamb-ended"}, description={"Contraction to treat as unambiguous (e.g., frien, thinkin)"}, paramLabel="word")
    private String[] mEndedUnambiguous;
    @CommandLine.Option(names={"-ab", "--amb-began"}, description={"Contraction to treat as ambiguous (e.g., sup, kay)"}, paramLabel="word")
    private String[] mBeganAmbiguous;
    @CommandLine.Option(names={"-ae", "--amb-ended"}, description={"Contraction to treat as ambiguous (e.g., gi, o)"}, paramLabel="word")
    private String[] mEndedAmbiguous;
    @CommandLine.Option(names={"-l", "--list"}, description={"List all ambiguous and unambiguous contractions"})
    private boolean mDisplayList;
    @CommandLine.Option(names={"-a", "--apostrophe"}, description={"Converted apostrophe entity (see docs)"})
    private String mApostrophe;
    @CommandLine.Option(names={"-x", "--xml", "--html", "--xhtml"}, description={"Convert quotation marks within XML or HTML documents"})
    private boolean mFilterXml;

    public Settings(KeenQuotes main) {
        assert (main != null);
        this.mMain = main;
    }

    boolean displayList() {
        return this.mDisplayList;
    }

    boolean filterXml() {
        return this.mFilterXml;
    }

    Apostrophe apostrophe() {
        return Apostrophe.fromType(this.mApostrophe);
    }

    List<String> getBeganUnambiguous() {
        return this.nullSafe(this.mBeganUnambiguous);
    }

    List<String> getEndedUnambiguous() {
        return this.nullSafe(this.mEndedUnambiguous);
    }

    List<String> getBeganAmbiguous() {
        return this.nullSafe(this.mBeganAmbiguous);
    }

    List<String> getEndedAmbiguous() {
        return this.nullSafe(this.mEndedAmbiguous);
    }

    private List<String> nullSafe(String[] words) {
        return words == null ? Collections.emptyList() : Arrays.asList(words);
    }

    @Override
    public Integer call() {
        this.mMain.run();
        return 0;
    }
}

