/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.lex;

import com.whitemagicsoftware.keenquotes.lex.Lexeme;
import com.whitemagicsoftware.keenquotes.lex.LexemeGlyph;
import com.whitemagicsoftware.keenquotes.lex.LexemeType;
import com.whitemagicsoftware.keenquotes.lex.LexerFilter;
import com.whitemagicsoftware.keenquotes.util.FastCharacterIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public final class Lexer {
    private static final Set<Character> DIGIT_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('\u00bc'), Character.valueOf('\u00bd'), Character.valueOf('\u00be'), Character.valueOf('\u2150'), Character.valueOf('\u2151'), Character.valueOf('\u2152'), Character.valueOf('\u2153'), Character.valueOf('\u2154'), Character.valueOf('\u2155'), Character.valueOf('\u2156'), Character.valueOf('\u2157'), Character.valueOf('\u2158'), Character.valueOf('\u2159'), Character.valueOf('\u215a'), Character.valueOf('\u215b'), Character.valueOf('\u215c'), Character.valueOf('\u215d'), Character.valueOf('\u215e')));
    private static final Set<Character> NUMERIC_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('.'), Character.valueOf(','), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('^'), Character.valueOf('\u215f'), Character.valueOf('\u2044')));
    private static final Set<Character> LETTER_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('_'), Character.valueOf('*')));

    public static void lex(String text, Consumer<Lexeme> emitter, LexerFilter filter) {
        Lexer.lex(new FastCharacterIterator(text), emitter, filter);
    }

    private static void lex(FastCharacterIterator i, Consumer<Lexeme> consumer, LexerFilter filter) {
        consumer.accept(Lexeme.SOT);
        while (i.hasNext()) {
            while (filter.test(i)) {
            }
            int index = i.index();
            char curr = i.current();
            LexemeType token = LexemeType.PUNCT;
            if (Lexer.isLetter(curr)) {
                i.skip(next -> Lexer.isLetter(next.charValue()) || Lexer.isDigit(next.charValue()));
                token = LexemeType.WORD;
            } else if (curr == ' ') {
                i.skip(next -> next.charValue() == ' ');
                token = LexemeType.SPACE;
            } else if (curr == '\r' || curr == '\n') {
                int[] cr = new int[]{curr == '\r' ? 1 : 0};
                int[] lf = new int[]{curr == '\n' ? 1 : 0};
                i.skip(next -> {
                    cr[0] = cr[0] + (next.charValue() == '\r' ? 1 : 0);
                    lf[0] = lf[0] + (next.charValue() == '\n' ? 1 : 0);
                    return next.charValue() == '\r' || next.charValue() == '\n';
                });
                token = cr[0] + lf[0] == 1 || cr[0] == 1 && lf[0] == 1 ? LexemeType.EOL : LexemeType.EOP;
            } else if (Character.isWhitespace(curr)) {
                i.skip(Character::isWhitespace);
                token = LexemeType.SPACE;
            } else if (Lexer.isDigit(curr) || Lexer.isNumeric(curr) && Lexer.isDigit(i.peek())) {
                i.skip(next -> Lexer.isDigit(next.charValue()) || Lexer.isNumeric(next.charValue()) && Lexer.isDigit(i.peek()));
                token = LexemeType.NUMBER;
            } else if (curr == '.') {
                i.skip(next -> next.charValue() == '.' || next.charValue() == ' ' && i.peek() == '.');
                token = i.index() - index == 0 ? LexemeType.PERIOD : LexemeType.ELLIPSIS;
            } else if (curr == '\"') {
                token = LexemeType.QUOTE_DOUBLE;
            } else if (curr == '\'') {
                token = LexemeType.QUOTE_SINGLE;
            } else if (Lexer.isHyphen(curr)) {
                int began = i.index();
                i.skip(Lexer::isHyphen);
                int count = i.index() - began;
                token = switch (count) {
                    case 0 -> LexemeType.HYPHEN;
                    case 1 -> LexemeType.DASH_EN;
                    case 2 -> LexemeType.DASH_EM;
                    default -> LexemeType.DASH_LINE;
                };
            } else if (curr == '\u2013') {
                token = LexemeType.DASH_EN;
            } else if (curr == '\u2014') {
                token = LexemeType.DASH_EM;
            } else if (curr == '(' || curr == '{' || curr == '[') {
                token = LexemeType.OPENING_GROUP;
            } else if (curr == ')' || curr == '}' || curr == ']') {
                token = LexemeType.CLOSING_GROUP;
            } else if (LexemeGlyph.LEX_DOUBLE_QUOTE_OPENING.equals(curr)) {
                token = LexemeType.QUOTE_DOUBLE_OPENING.with(LexemeGlyph.LEX_DOUBLE_QUOTE_OPENING);
            } else if (LexemeGlyph.LEX_DOUBLE_QUOTE_CLOSING.equals(curr)) {
                token = LexemeType.QUOTE_DOUBLE_CLOSING.with(LexemeGlyph.LEX_DOUBLE_QUOTE_CLOSING);
            } else if (LexemeGlyph.LEX_SINGLE_QUOTE_OPENING.equals(curr)) {
                token = LexemeType.QUOTE_SINGLE_OPENING.with(LexemeGlyph.LEX_SINGLE_QUOTE_OPENING);
            } else if (LexemeGlyph.LEX_SINGLE_QUOTE_CLOSING.equals(curr)) {
                token = LexemeType.QUOTE_SINGLE_CLOSING.with(LexemeGlyph.LEX_SINGLE_QUOTE_CLOSING);
            } else if (LexemeGlyph.LEX_SINGLE_CHEVRON_LEFT.equals(curr)) {
                token = LexemeType.QUOTE_SINGLE_CHEVRON_OPENING.with(LexemeGlyph.LEX_SINGLE_CHEVRON_LEFT);
            } else if (LexemeGlyph.LEX_DOUBLE_CHEVRON_LEFT.equals(curr)) {
                token = LexemeType.QUOTE_DOUBLE_CHEVRON_OPENING.with(LexemeGlyph.LEX_DOUBLE_CHEVRON_LEFT);
            } else if (LexemeGlyph.LEX_SINGLE_CHEVRON_RIGHT.equals(curr)) {
                token = LexemeType.QUOTE_SINGLE_CHEVRON_CLOSING.with(LexemeGlyph.LEX_SINGLE_CHEVRON_RIGHT);
            } else if (LexemeGlyph.LEX_DOUBLE_CHEVRON_RIGHT.equals(curr)) {
                token = LexemeType.QUOTE_DOUBLE_CHEVRON_CLOSING.with(LexemeGlyph.LEX_DOUBLE_CHEVRON_RIGHT);
            } else if (curr == '\\') {
                char next2 = i.advance();
                if (next2 == '\'') {
                    token = LexemeType.ESC_SINGLE;
                } else if (next2 == '\"') {
                    token = LexemeType.ESC_DOUBLE;
                } else {
                    i.prev();
                }
            } else if (curr == '=') {
                token = LexemeType.EQUALS;
            } else if (curr == ',' && i.peek() == ',') {
                i.skip(next -> next.charValue() == ',');
                token = LexemeType.QUOTE_DOUBLE_OPENING.with(LexemeGlyph.LEX_DOUBLE_QUOTE_OPENING_LOW);
            } else if (LexemeGlyph.LEX_DOUBLE_QUOTE_OPENING_LOW.equals(curr)) {
                token = LexemeType.QUOTE_DOUBLE_OPENING.with(LexemeGlyph.LEX_DOUBLE_QUOTE_OPENING_LOW);
            } else if (LexemeGlyph.LEX_SINGLE_CHEVRON_LEFT.equals(curr)) {
                token = LexemeType.QUOTE_SINGLE_OPENING.with(LexemeGlyph.LEX_SINGLE_CHEVRON_LEFT);
            } else if (LexemeGlyph.LEX_DOUBLE_CHEVRON_LEFT.equals(curr)) {
                token = LexemeType.QUOTE_DOUBLE_OPENING.with(LexemeGlyph.LEX_DOUBLE_CHEVRON_LEFT);
            } else if (LexemeGlyph.LEX_SINGLE_CHEVRON_RIGHT.equals(curr)) {
                token = LexemeType.QUOTE_SINGLE_CLOSING.with(LexemeGlyph.LEX_SINGLE_CHEVRON_RIGHT);
            } else if (LexemeGlyph.LEX_DOUBLE_CHEVRON_RIGHT.equals(curr)) {
                token = LexemeType.QUOTE_DOUBLE_CLOSING.with(LexemeGlyph.LEX_DOUBLE_CHEVRON_RIGHT);
            } else if (curr == '\uffff') break;
            assert (index >= 0);
            consumer.accept(new Lexeme(token, index, i.index() + 1));
            i.next();
        }
        consumer.accept(new Lexeme(LexemeType.EOL, i.index(), i.index()));
        consumer.accept(new Lexeme(LexemeType.EOP, i.index(), i.index()));
        consumer.accept(Lexeme.EOT);
    }

    private static boolean isLetter(char curr) {
        return Character.isLetter(curr) || LETTER_CHARS.contains(Character.valueOf(curr));
    }

    private static boolean isDigit(char curr) {
        return Character.isDigit(curr) || DIGIT_CHARS.contains(Character.valueOf(curr));
    }

    private static boolean isHyphen(char curr) {
        return curr == '-';
    }

    private static boolean isNumeric(char curr) {
        return NUMERIC_CHARS.contains(Character.valueOf(curr));
    }
}

