/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.parser;

public enum Apostrophe {
    CONVERT_REGULAR("", "regular"),
    CONVERT_MODIFIER("&#x2bc;", "modifier"),
    CONVERT_APOS("&apos;", "apos"),
    CONVERT_APOS_HEX("&#x27;", "aposhex"),
    CONVERT_RSQUOTE("&rsquo;", "quote"),
    CONVERT_RSQUOTE_HEX("&#8217;", "quotehex");

    private final String mCode;
    private final String mType;

    private Apostrophe(String code, String type) {
        this.mCode = code;
        this.mType = type;
    }

    public boolean isType(String type) {
        return this.mType.equalsIgnoreCase(type);
    }

    public String toString() {
        return this.mCode;
    }

    public static Apostrophe fromType(String type) {
        for (Apostrophe apostrophe : Apostrophe.values()) {
            if (!apostrophe.isType(type)) continue;
            return apostrophe;
        }
        return CONVERT_REGULAR;
    }
}

