/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.base;

import com.whitemagicsoftware.keentype.base.KtEqTable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class KtLevelEqTable
extends KtEqTable
implements Serializable {
    private final Map<KtTabKey, KtTabEntry> table = new HashMap<KtTabKey, KtTabEntry>(1024);
    private KtSavEntry saves;
    private int level;

    public final int getLevel() {
        return this.level;
    }

    public void pushLevel() {
        ++this.level;
    }

    public void popLevel() {
        KtSavEntry s;
        if (this.level == 0) {
            return;
        }
        while ((s = this.saves) != null && s.sav == this.level) {
            s.restore(this.table);
            this.saves = s.next;
        }
        --this.level;
    }

    private Object get(KtTabKey k) {
        KtTabEntry e = this.table.get(k);
        return e == null ? null : e.val;
    }

    private void put(KtTabKey k, Serializable v) {
        KtTabEntry e;
        if (this.level > 0 && ((e = this.table.get(k)) == null || e.lev != this.level)) {
            this.saves = new KtIntSavEntry(k, e, this.level, this.saves);
        }
        this.table.put(k, new KtTabEntry(v, this.level));
    }

    private void nastyReplace(KtTabKey k, Serializable v) {
        KtTabEntry e = this.table.get(k);
        if (e != null) {
            e.val = v;
        } else {
            if (this.level > 0) {
                this.saves = new KtIntSavEntry(k, e, this.level, this.saves);
            }
            this.table.put(k, new KtTabEntry(v, this.level));
        }
    }

    private void gput(KtTabKey k, Serializable v) {
        this.table.put(k, new KtTabEntry(v, 0));
    }

    @Override
    public final Object get(KtEqTable.KtNumKind kind, int key) {
        return this.get(new KtNumKey(kind, key));
    }

    @Override
    public final void put(KtEqTable.KtNumKind kind, int key, Serializable val) {
        this.put(new KtNumKey(kind, key), val);
    }

    @Override
    public final void nastyReplace(KtEqTable.KtNumKind kind, int key, Serializable val) {
        this.nastyReplace(new KtNumKey(kind, key), val);
    }

    @Override
    public final void gput(KtEqTable.KtNumKind kind, int key, Serializable val) {
        this.gput(new KtNumKey(kind, key), val);
    }

    @Override
    public final Object get(KtEqTable.KtObjKind kind, Serializable key) {
        return this.get(new KtObjKey(kind, key));
    }

    @Override
    public final void put(KtEqTable.KtObjKind kind, Serializable key, Serializable val) {
        this.put(new KtObjKey(kind, key), val);
    }

    @Override
    public final void nastyReplace(KtEqTable.KtObjKind kind, Serializable key, Serializable val) {
        this.nastyReplace(new KtObjKey(kind, key), val);
    }

    @Override
    public final void gput(KtEqTable.KtObjKind kind, Serializable key, Serializable val) {
        this.gput(new KtObjKey(kind, key), val);
    }

    @Override
    public void save(KtEqTable.KtExtEquiv ext) {
        int l;
        if (this.level > 0 && (l = ext.getEqLevel()) != this.level) {
            this.saves = new KtExtSavEntry(ext.getEqValue(), l, ext, this.level, this.saves);
        }
        ext.setEqLevel(this.level);
    }

    private static abstract class KtSavEntry
    implements Serializable {
        final int sav;
        final KtSavEntry next;

        KtSavEntry(int s, KtSavEntry x) {
            this.sav = s;
            this.next = x;
        }

        abstract void restore(Map<KtTabKey, KtTabEntry> var1);
    }

    private static final class KtTabEntry
    implements Serializable {
        Object val;
        int lev;

        KtTabEntry(Object v, int l) {
            this.val = v;
            this.lev = l;
        }
    }

    private static final class KtIntSavEntry
    extends KtSavEntry {
        final KtTabKey key;
        final KtTabEntry ent;

        KtIntSavEntry(KtTabKey k, KtTabEntry e, int s, KtSavEntry x) {
            super(s, x);
            this.key = k;
            this.ent = e;
        }

        @Override
        void restore(Map<KtTabKey, KtTabEntry> tab) {
            KtTabEntry e = tab.get(this.key);
            if (this.ent == null) {
                if (e != null && e.lev > 0) {
                    tab.remove(this.key);
                    this.key.restored(e.val);
                } else {
                    this.key.retained();
                }
            } else if (e == null || this.ent.lev < e.lev) {
                tab.put(this.key, this.ent);
                this.key.restored(e != null ? e.val : null);
            } else {
                this.key.retained();
            }
        }
    }

    private static interface KtTabKey
    extends Serializable {
        public void restored(Object var1);

        public void retained();
    }

    private static final class KtNumKey
    implements KtTabKey {
        private final KtEqTable.KtNumKind kind;
        private final int num;

        public KtNumKey(KtEqTable.KtNumKind k, int n) {
            this.kind = k;
            this.num = n;
        }

        @Override
        public void restored(Object oldVal) {
            this.kind.restored(this.num, oldVal);
        }

        @Override
        public void retained() {
            this.kind.retained(this.num);
        }

        public int hashCode() {
            return this.kind.hashCode() * 383 + this.num;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof KtNumKey)) return false;
            KtNumKey k = (KtNumKey)o;
            if (!k.kind.equals(this.kind)) return false;
            if (k.num != this.num) return false;
            return true;
        }
    }

    private static final class KtObjKey
    implements KtTabKey {
        private final KtEqTable.KtObjKind kind;
        private final Object obj;

        public KtObjKey(KtEqTable.KtObjKind k, Object o) {
            this.kind = k;
            this.obj = o;
        }

        @Override
        public void restored(Object oldVal) {
            this.kind.restored(this.obj, oldVal);
        }

        @Override
        public void retained() {
            this.kind.retained(this.obj);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof KtObjKey)) return false;
            KtObjKey k = (KtObjKey)o;
            if (!k.kind.equals(this.kind)) return false;
            if (!k.obj.equals(this.obj)) return false;
            return true;
        }

        public int hashCode() {
            return this.kind.hashCode() * 383 + this.obj.hashCode();
        }
    }

    private static final class KtExtSavEntry
    extends KtSavEntry {
        final Object val;
        final int lev;
        final KtEqTable.KtExtEquiv ext;

        KtExtSavEntry(Object v, int l, KtEqTable.KtExtEquiv e, int s, KtSavEntry x) {
            super(s, x);
            this.val = v;
            this.lev = l;
            this.ext = e;
        }

        @Override
        void restore(Map<KtTabKey, KtTabEntry> tab) {
            if (this.lev < this.ext.getEqLevel()) {
                this.ext.restoreEqValue(this.val);
                this.ext.setEqLevel(this.lev);
            } else {
                this.ext.retainEqValue();
            }
        }
    }
}

