/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.builder;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.builder.KtListBuilder;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtBoxLeaders;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtHKernNode;
import com.whitemagicsoftware.keentype.node.KtHLeadRuleNode;
import com.whitemagicsoftware.keentype.node.KtHLeadersNode;
import com.whitemagicsoftware.keentype.node.KtHSkipNode;
import com.whitemagicsoftware.keentype.node.KtLeaders;
import com.whitemagicsoftware.keentype.node.KtNamedHSkipNode;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtRuleNode;

public abstract class KtHorizBuilder
extends KtListBuilder {
    public static final int NORMAL_SPACE_FACTOR = 1000;
    private int spaceFactor = 1000;

    protected KtHorizBuilder(int line, KtNodeList list) {
        super(line, list);
    }

    protected KtHorizBuilder(int line) {
        super(line);
    }

    @Override
    public boolean isHorizontal() {
        return true;
    }

    @Override
    public boolean isCharAllowed() {
        return true;
    }

    @Override
    public void addKern(KtDimen kern) {
        this.addNode(new KtHKernNode(kern));
    }

    @Override
    public void addSkip(KtGlue skip) {
        this.addNode(new KtHSkipNode(skip));
    }

    @Override
    public void addNamedSkip(KtGlue skip, String name) {
        this.addNode(new KtNamedHSkipNode(skip, name));
    }

    @Override
    public void addRule(KtBoxSizes sizes) {
        this.addNode(new KtRuleNode(sizes));
        this.resetSpaceFactor();
    }

    @Override
    public void addLeaders(KtGlue skip, KtLeaders lead) {
        this.addNode(new KtHLeadersNode(skip, lead));
    }

    @Override
    public void addLeadRule(KtGlue skip, KtBoxSizes sizes, String desc) {
        this.addNode(new KtHLeadRuleNode(skip, sizes, desc));
    }

    @Override
    public KtBoxLeaders.KtMover getBoxLeadMover() {
        return KtHLeadersNode.BOX_MOVER;
    }

    @Override
    public void addBox(KtNode box) {
        super.addBox(box);
        this.resetSpaceFactor();
    }

    @Override
    protected KtNodeEnum unBoxList(KtBox box) {
        return box.getHorizList();
    }

    @Override
    public void adjustSpaceFactor(int sf) {
        if (sf > 0) {
            this.spaceFactor = sf <= 1000 || this.spaceFactor >= 1000 ? sf : 1000;
        }
    }

    @Override
    public int getSpaceFactor() {
        return this.spaceFactor;
    }

    @Override
    public int nearestValidSpaceFactor() {
        return this.spaceFactor;
    }

    @Override
    public void setSpaceFactor(int sf) {
        if (sf > 0) {
            this.spaceFactor = sf;
        }
    }

    @Override
    public void resetSpaceFactor() {
        this.spaceFactor = 1000;
    }

    @Override
    protected void specialShow(KtLog log) {
        log.startLine().add("spacefactor ").add(this.getSpaceFactor());
    }
}

