/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.hyph;

import com.whitemagicsoftware.keentype.hyph.KtWordMap;
import java.io.Serializable;

public class KtWordTrie
implements KtWordMap {
    public static final KtWordTrie NULL = null;
    public static final Entry NULL_ENTRY = null;
    private static final Entry[] EMPTY_TABLE = new Entry[]{new Entry('\u0000', 0, null)};
    public static final KtWordTrie EMPTY = new KtWordTrie(EMPTY_TABLE);
    private final Entry[] table;

    public KtWordTrie(Entry[] table) {
        this.table = table;
    }

    @Override
    public Object get(String word) {
        int size = word.length();
        int curr = 0;
        for (int i = 0; i < size; ++i) {
            char code = word.charAt(i);
            curr = this.table[curr].link;
            if (curr == 0) {
                return null;
            }
            if ((curr += code) <= 0 || curr >= this.table.length) {
                return null;
            }
            Entry ent = this.table[curr];
            if (ent != NULL_ENTRY && ent.code == code) continue;
            return null;
        }
        return this.table[curr].value;
    }

    @Override
    public Object put(String word, Object value) {
        throw new UnsupportedOperationException("packed");
    }

    @Override
    public KtWordMap.KtSeeker seeker() {
        return new KtSeeker();
    }

    static class Entry
    implements Serializable {
        final char code;
        final int link;
        Object value;

        public Entry(char code, int link, Object value) {
            this.code = code;
            this.link = link;
            this.value = value;
        }
    }

    public class KtSeeker
    implements KtWordMap.KtSeeker {
        private int curr = 0;

        @Override
        public void reset() {
            this.curr = 0;
        }

        @Override
        public boolean isValid() {
            return this.curr >= 0;
        }

        @Override
        public void seek(char code) {
            if (this.curr >= 0) {
                this.curr = KtWordTrie.this.table[this.curr].link;
                if (this.curr != 0) {
                    Entry ent;
                    this.curr += code;
                    if (this.curr > 0 && this.curr < KtWordTrie.this.table.length && (ent = KtWordTrie.this.table[this.curr]) != NULL_ENTRY && ent.code == code) {
                        return;
                    }
                }
                this.curr = -1;
            }
        }

        @Override
        public Object get() {
            return this.curr > 0 ? KtWordTrie.this.table[this.curr].value : null;
        }
    }
}

