/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.math;

import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.math.KtMathPrim;

class KtMathGiven
extends KtCommand
implements KtNum.KtProvider {
    private final int code;
    private final String name;

    public KtMathGiven(int code, String name) {
        this.code = code;
        this.name = name;
    }

    @Override
    public void exec(KtToken src) {
        KtMathPrim.handleMathCode(this.code, src);
    }

    @Override
    public boolean hasMathCodeValue() {
        return true;
    }

    @Override
    public int getMathCodeValue() {
        return this.code;
    }

    @Override
    public boolean sameAs(KtCommand cmd) {
        return cmd instanceof KtMathGiven && this.code == ((KtMathGiven)cmd).code;
    }

    @Override
    public void addOn(KtLog log) {
        log.addEsc(this.name).add('\"').add(Integer.toHexString(this.code).toUpperCase());
    }

    @Override
    public boolean hasNumValue() {
        return true;
    }

    @Override
    public KtNum getNumValue() {
        return KtNum.valueOf(this.code);
    }

    public final String toString() {
        return "[mathchar given: " + this.code + "]";
    }
}

