/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.noad;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.noad.KtDelimiter;
import com.whitemagicsoftware.keentype.noad.KtTransfConstants;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtMathWordBuilder;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtTreatNode;

public abstract class KtConvStyle
implements KtTransfConstants {
    protected final byte style;
    protected final boolean cramped;
    protected final KtDimen currMu;
    private static final byte[] dimFamilies = new byte[23];
    private static final int[] dimFontPars = new int[23];
    public static final byte SYMBOL_FAMILY = 2;
    public static final byte EXTENSION_FAMILY = 3;

    protected KtConvStyle(byte style, boolean cramped) {
        this.style = style;
        this.cramped = cramped;
        this.setupFontSize();
        this.currMu = this.getDimPar(1).over(18);
    }

    protected abstract void setupFontSize();

    protected abstract KtFontMetric fetchFontMetric(byte var1);

    public byte getStyle() {
        return this.style;
    }

    public boolean isCramped() {
        return this.cramped;
    }

    public KtDimen muToPt(KtDimen dim) {
        return dim.times(this.currMu);
    }

    public KtGlue muToPt(KtGlue skip) {
        return skip.timesTheFinite(this.currMu);
    }

    public abstract KtNode fetchCharNode(byte var1, KtCharCode var2);

    public abstract KtNode fetchLargerNode(byte var1, KtCharCode var2);

    public abstract KtNode fetchSufficientNode(KtDelimiter var1, KtDimen var2);

    public abstract KtBox fetchFittingWidthBox(byte var1, KtCharCode var2, KtDimen var3);

    public abstract KtDimen skewAmount(byte var1, KtCharCode var2);

    public abstract KtDimen getXHeight(byte var1);

    public abstract KtDimen delimiterSize(KtDimen var1, KtDimen var2);

    public abstract KtDimen scriptSpace();

    public abstract KtNode getSpacing(byte var1, byte var2);

    public abstract KtNum getPenalty(byte var1, byte var2);

    public abstract boolean isScript();

    public abstract KtConvStyle makeNew(byte var1);

    public abstract boolean forcedItalCorr(byte var1);

    public abstract KtMathWordBuilder getWordBuilder(byte var1, KtTreatNode var2);

    public KtConvStyle derived(byte how) {
        int s = this.style;
        boolean c = this.cramped;
        switch (how) {
            case 1: {
                c = true;
                break;
            }
            case 2: {
                c = true;
            }
            case 3: {
                s = switch (this.style) {
                    case 0, 1 -> 2;
                    default -> 3;
                };
                break;
            }
            case 5: {
                c = true;
            }
            case 4: {
                s = switch (this.style) {
                    case 0 -> 1;
                    case 1 -> 2;
                    default -> 3;
                };
            }
        }
        return this.deriveNew((byte)s, c);
    }

    protected abstract KtConvStyle deriveNew(byte var1, boolean var2);

    public KtDimen getDimPar(int param) {
        return this.fetchFontMetric(dimFamilies[param]).getDimenParam(dimFontPars[param]);
    }

    private static void initSymbolPar(int param, int fontPar) {
        KtConvStyle.dimFamilies[param] = 2;
        KtConvStyle.dimFontPars[param] = fontPar;
    }

    private static void initExtensionPar(int param, int fontPar) {
        KtConvStyle.dimFamilies[param] = 3;
        KtConvStyle.dimFontPars[param] = fontPar;
    }

    static {
        KtConvStyle.initSymbolPar(0, 7);
        KtConvStyle.initSymbolPar(1, 8);
        KtConvStyle.initSymbolPar(2, 9);
        KtConvStyle.initSymbolPar(3, 10);
        KtConvStyle.initSymbolPar(4, 11);
        KtConvStyle.initSymbolPar(5, 12);
        KtConvStyle.initSymbolPar(6, 13);
        KtConvStyle.initSymbolPar(7, 14);
        KtConvStyle.initSymbolPar(8, 15);
        KtConvStyle.initSymbolPar(9, 16);
        KtConvStyle.initSymbolPar(10, 17);
        KtConvStyle.initSymbolPar(11, 18);
        KtConvStyle.initSymbolPar(12, 19);
        KtConvStyle.initSymbolPar(13, 20);
        KtConvStyle.initSymbolPar(14, 21);
        KtConvStyle.initSymbolPar(15, 22);
        KtConvStyle.initSymbolPar(16, 23);
        KtConvStyle.initExtensionPar(17, 24);
        KtConvStyle.initExtensionPar(18, 25);
        KtConvStyle.initExtensionPar(19, 26);
        KtConvStyle.initExtensionPar(20, 27);
        KtConvStyle.initExtensionPar(21, 28);
        KtConvStyle.initExtensionPar(22, 29);
    }
}

