/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.noad;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.noad.KtConverter;
import com.whitemagicsoftware.keentype.noad.KtEgg;
import com.whitemagicsoftware.keentype.noad.KtNodeField;
import com.whitemagicsoftware.keentype.noad.KtScriptableNoad;
import com.whitemagicsoftware.keentype.noad.KtStItalNodeEgg;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtHShiftNode;
import com.whitemagicsoftware.keentype.node.KtNode;

public class KtVCenterNoad
extends KtScriptableNoad {
    protected final KtNodeField nucleus;

    public KtVCenterNoad(KtNodeField nucleus) {
        this.nucleus = nucleus;
    }

    @Override
    public void addOn(KtLog log, KtCntxLog cntx) {
        log.addEsc(this.getDesc());
        this.nucleus.addOn(log, cntx, '.');
    }

    protected String getDesc() {
        return "vcenter";
    }

    @Override
    public boolean isJustChar() {
        return this.nucleus.isJustChar();
    }

    @Override
    public KtEgg convert(KtConverter conv) {
        KtNode node = this.nucleus.getNode();
        KtDimen middle = conv.getDimPar(16);
        if (node.isBox()) {
            KtBox box = node.getBox();
            KtBoxSizes sizes = box.getSizes();
            KtDimen shift = this.delta(sizes.getHeight(), sizes.getDepth(), middle);
            node = box.pretendSizesCopy(sizes.shiftedUp(shift));
        } else {
            KtDimen shift = this.delta(node.getHeight(), node.getDepth(), middle);
            node = KtHShiftNode.shiftingUp(node, shift);
        }
        return new KtStItalNodeEgg(node, 0);
    }

    private KtDimen delta(KtDimen height, KtDimen depth, KtDimen middle) {
        return depth.minus(height).halved().plus(middle);
    }
}

