/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtLeaders;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtSettingContext;
import com.whitemagicsoftware.keentype.node.KtTypesetter;
import java.io.Serializable;

public abstract class KtBoxLeaders
implements KtLeaders {
    public static final KtMover NULL_MOVER = null;
    protected final KtNode node;
    protected final KtMover mover;
    private static final KtDimen compensation = KtDimen.valueOf(10, 65536);

    public KtBoxLeaders(KtNode node, KtMover mover) {
        this.node = node;
        this.mover = mover;
    }

    @Override
    public KtDimen getHeight() {
        return this.node.getHeight();
    }

    @Override
    public KtDimen getWidth() {
        return this.node.getWidth();
    }

    @Override
    public KtDimen getDepth() {
        return this.node.getDepth();
    }

    @Override
    public KtDimen getLeftX() {
        return this.node.getLeftX();
    }

    @Override
    public void addOn(KtLog log, KtCntxLog cntx, KtGlue skip) {
        log.addEsc(this.getDesc()).add(' ').add(skip.toString());
        cntx.addOn(log, this.node);
    }

    @Override
    public void typeSet(KtTypesetter setter, KtDimen size, KtSettingContext sctx) {
        KtDimen nodeSize;
        if (size.moreThan(0) && (nodeSize = this.mover.size(this.node)).moreThan(0)) {
            this.typeSet(setter, sctx.allowingIO(false), size.plus(compensation), nodeSize);
        }
    }

    protected void typeSet(KtTypesetter setter, KtSettingContext sctx, int count, KtDimen start, KtDimen gap) {
        this.mover.move(setter, start);
        while (count-- > 0) {
            this.mover.movePrev(setter, this.node);
            this.node.typeSet(setter, sctx);
            this.mover.movePast(setter, this.node);
            this.mover.move(setter, gap);
        }
    }

    protected abstract void typeSet(KtTypesetter var1, KtSettingContext var2, KtDimen var3, KtDimen var4);

    protected abstract String getDesc();

    public static interface KtMover
    extends Serializable {
        public KtDimen offset(KtTypesetter.KtMark var1);

        public KtDimen size(KtNode var1);

        public void move(KtTypesetter var1, KtDimen var2);

        public void movePrev(KtTypesetter var1, KtNode var2);

        public void movePast(KtTypesetter var1, KtNode var2);
    }
}

