/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tfm;

import com.whitemagicsoftware.keentype.base.KtBinFraction;
import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtName;
import com.whitemagicsoftware.keentype.node.KtBaseFontMetric;
import com.whitemagicsoftware.keentype.node.KtBaseNode;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtChrKernNode;
import com.whitemagicsoftware.keentype.node.KtDiscretionaryNode;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtGlueSetting;
import com.whitemagicsoftware.keentype.node.KtHBoxNode;
import com.whitemagicsoftware.keentype.node.KtMathWordBuilder;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtSettingContext;
import com.whitemagicsoftware.keentype.node.KtTreatNode;
import com.whitemagicsoftware.keentype.node.KtTypesetter;
import com.whitemagicsoftware.keentype.node.KtVBoxNode;
import com.whitemagicsoftware.keentype.node.KtWordBuilder;
import com.whitemagicsoftware.keentype.node.KtWordRebuilder;
import com.whitemagicsoftware.keentype.tfm.KtFixWord;
import com.whitemagicsoftware.keentype.tfm.KtTeXFm;
import com.whitemagicsoftware.keentype.tfm.KtTeXLigKernBuilder;
import com.whitemagicsoftware.keentype.tfm.KtTeXMathExtFm;
import com.whitemagicsoftware.keentype.tfm.KtTeXMathSymFm;

public class KtTeXFontMetric
extends KtBaseFontMetric {
    private static final int[] pTab = new int[30];
    private final KtName name;
    private final KtTeXFm tfm;
    private final KtDimen atSize;
    private KtName ident;

    public static int numberOfRawDimenPars() {
        return pTab.length;
    }

    public static int rawDimenParNumber(int idx) {
        return pTab[idx];
    }

    public KtTeXFontMetric(KtName name, KtTeXFm tfm, KtDimen atSize, KtName ident) {
        this.name = name;
        this.tfm = tfm;
        this.atSize = atSize;
        this.ident = ident;
        for (int i = 0; i < pTab.length; ++i) {
            if (pTab[i] < 0) continue;
            this.setTfmParam(i, pTab[i]);
        }
    }

    private void setTfmParam(int i, int tfmIdx) {
        KtFixWord param;
        if (0 <= tfmIdx && tfmIdx < this.tfm.paramCount() && (param = this.tfm.getParam(tfmIdx)) != KtFixWord.NULL) {
            KtDimen val = tfmIdx == KtTeXFm.FP_SLANT ? KtDimen.valueOf(param) : this.atSize.times(param);
            this.setDimenParam(i, val);
        }
    }

    @Override
    public KtName getName() {
        return this.name;
    }

    public KtDimen getAtSize() {
        return this.atSize;
    }

    @Override
    public KtName getIdent() {
        return this.ident;
    }

    public void setIdent(KtName ident) {
        this.ident = ident;
    }

    public int getCheckSum() {
        return this.tfm.getCheckSum();
    }

    public KtDimen getDesignSize() {
        return KtDimen.valueOf(this.tfm.getDesignSize());
    }

    @Override
    public void addDescOn(KtLog log) {
        log.add(this.name);
        if (!this.atSize.equals(this.tfm.getDesignSize())) {
            log.add(" at " + String.valueOf(this.atSize) + "pt");
        }
    }

    private short indexFrom(char chr) {
        return (short)(chr != '\uffff' ? (int)chr : -1);
    }

    private KtTeXFm.KtCharInfo getCharInfo(short index) {
        return index == -1 ? KtTeXFm.KtCharInfo.NULL : this.tfm.getCharInfo(index);
    }

    private KtTeXFm.KtCharInfo getCharInfo(KtCharCode code) {
        char chr = code.toChar();
        return chr != '\uffff' ? this.tfm.getCharInfo((short)chr) : KtTeXFm.KtCharInfo.NULL;
    }

    @Override
    public KtNode getCharNode(KtCharCode code) {
        KtTeXFm.KtCharInfo info = this.getCharInfo(code);
        return info == KtTeXFm.KtCharInfo.NULL ? KtNode.NULL : new KtCharNode(this.atSize.times(info.getWidth()), this.atSize.times(info.getHeight()), this.atSize.times(info.getDepth()), code);
    }

    public KtDimen getCharWidth(char chr) {
        KtTeXFm.KtCharInfo info = this.tfm.getCharInfo((short)chr);
        return info != KtTeXFm.KtCharInfo.NULL ? this.atSize.times(info.getWidth()) : KtDimen.NULL;
    }

    @Override
    public KtWordBuilder getWordBuilder(KtTreatNode proc, boolean boundary, boolean discretionaries) {
        return new KtLigKernBuilder(boundary, proc, discretionaries, true);
    }

    @Override
    public KtWordRebuilder getWordRebuilder(KtTreatNode proc, boolean boundary) {
        return new KtLigKernBuilder(boundary, proc);
    }

    @Override
    public KtMathWordBuilder getMathWordBuilder(KtTreatNode proc) {
        return new KtMathLigKernBuilder(proc);
    }

    @Override
    public KtNode getLargerNode(KtCharCode code) {
        KtTeXFm.KtCharInfo info;
        KtNode node = KtNode.NULL;
        short index = this.indexFrom(code.toChar());
        if (index != -1 && (info = this.tfm.getCharInfo(index)) != KtTeXFm.KtCharInfo.NULL) {
            node = this.largerNode(index, info);
        }
        return node;
    }

    private KtNode largerNode(short index, KtTeXFm.KtCharInfo info) {
        KtTeXFm.KtCharInfo nextInfo;
        short nextIndex = info.nextChar();
        if (nextIndex != -1 && (nextInfo = this.tfm.getCharInfo(nextIndex)) != KtTeXFm.KtCharInfo.NULL) {
            index = nextIndex;
            info = nextInfo;
        }
        return this.indexNode(index, info);
    }

    @Override
    public KtNode getSufficientNode(KtCharCode code, KtDimen desired) {
        KtTeXFm.KtCharInfo info;
        short maxIndex = -1;
        KtTeXFm.KtCharInfo maxInfo = KtTeXFm.KtCharInfo.NULL;
        KtDimen maxSize = KtDimen.ZERO;
        short index = this.indexFrom(code.toChar());
        while (index != -1 && (info = this.tfm.getCharInfo(index)) != KtTeXFm.KtCharInfo.NULL) {
            if (info.extRep() != -1) {
                return this.makeExt(info, desired);
            }
            KtDimen size = this.heightPlusDepth(info);
            if (size.moreThan(maxSize)) {
                maxIndex = index;
                maxInfo = info;
                maxSize = size;
                if (!size.lessThan(desired)) break;
            }
            index = info.nextChar();
        }
        return maxInfo != KtTeXFm.KtCharInfo.NULL ? this.pretendingCharBox(maxIndex, maxInfo) : KtNode.NULL;
    }

    private KtNode makeExt(KtTeXFm.KtCharInfo info, KtDimen size) {
        KtTeXFm.KtCharInfo topInfo = this.getCharInfo(info.extTop());
        KtTeXFm.KtCharInfo midInfo = this.getCharInfo(info.extMid());
        KtTeXFm.KtCharInfo botInfo = this.getCharInfo(info.extBot());
        KtTeXFm.KtCharInfo repInfo = this.getCharInfo(info.extRep());
        if (repInfo != KtTeXFm.KtCharInfo.NULL) {
            KtDimen total = KtDimen.ZERO;
            KtDimen rep = this.heightPlusDepth(repInfo);
            if (topInfo != KtTeXFm.KtCharInfo.NULL) {
                total = total.plus(this.heightPlusDepth(topInfo));
            }
            if (midInfo != KtTeXFm.KtCharInfo.NULL) {
                total = total.plus(this.heightPlusDepth(midInfo));
                rep = rep.times(2);
            }
            if (botInfo != KtTeXFm.KtCharInfo.NULL) {
                total = total.plus(this.heightPlusDepth(botInfo));
            }
            int cnt = 0;
            if (rep.moreThan(0)) {
                while (total.lessThan(size)) {
                    total = total.plus(rep);
                    ++cnt;
                }
            }
            KtNodeList list = new KtNodeList();
            KtHBoxNode repNode = this.pretendingCharBox(info.extRep(), repInfo);
            if (topInfo != KtTeXFm.KtCharInfo.NULL) {
                list.append(this.pretendingCharBox(info.extTop(), topInfo));
            }
            int i = cnt;
            while (i-- > 0) {
                list.append(repNode);
            }
            if (midInfo != KtTeXFm.KtCharInfo.NULL) {
                list.append(this.pretendingCharBox(info.extMid(), midInfo));
                i = cnt;
                while (i-- > 0) {
                    list.append(repNode);
                }
            }
            if (botInfo != KtTeXFm.KtCharInfo.NULL) {
                list.append(this.pretendingCharBox(info.extBot(), botInfo));
            }
            KtDimen height = list.isEmpty() ? KtDimen.ZERO : list.nodeAt(0).getHeight();
            KtDimen width = this.atSize.times(repInfo.getWidth()).plus(this.atSize.times(repInfo.getItalic()));
            return new KtVBoxNode(new KtBoxSizes(height, width, total.minus(height), KtDimen.ZERO), KtGlueSetting.NATURAL, list);
        }
        return KtNode.NULL;
    }

    @Override
    public KtBox getFittingWidthBox(KtCharCode code, KtDimen desired) {
        KtTeXFm.KtCharInfo info;
        KtBox box = KtBox.NULL;
        short index = this.indexFrom(code.toChar());
        if (index != -1 && (info = this.tfm.getCharInfo(index)) != KtTeXFm.KtCharInfo.NULL) {
            KtTeXFm.KtCharInfo maxInfo;
            short maxIndex;
            do {
                maxIndex = index;
                maxInfo = info;
            } while ((index = info.nextChar()) != -1 && (info = this.tfm.getCharInfo(index)) != KtTeXFm.KtCharInfo.NULL && !this.atSize.times(info.getWidth()).moreThan(desired));
            box = this.pretendingCharBox(maxIndex, maxInfo);
        }
        return box;
    }

    @Override
    public KtDimen getKernBetween(KtCharCode left, KtCharCode right) {
        KtFixWord kern;
        KtTeXFm.KtLigKern ligKern = this.tfm.getLigKern(this.indexFrom(left.toChar()), this.indexFrom(right.toChar()));
        if (ligKern != KtTeXFm.KtLigKern.NULL && (kern = ligKern.getKern()) != KtFixWord.NULL) {
            return this.atSize.times(kern);
        }
        return KtDimen.NULL;
    }

    private KtDimen heightPlusDepth(KtTeXFm.KtCharInfo info) {
        return this.atSize.times(info.getHeight()).plus(this.atSize.times(info.getDepth()));
    }

    private KtIndexNode indexNode(short index, KtTeXFm.KtCharInfo info) {
        return new KtIndexNode(this.atSize.times(info.getWidth()), this.atSize.times(info.getHeight()), this.atSize.times(info.getDepth()), index);
    }

    private KtHBoxNode pretendingCharBox(short index, KtTeXFm.KtCharInfo info) {
        KtIndexNode node = this.indexNode(index, info);
        KtDimen width = node.getWidth();
        KtDimen ital = node.getItalCorr();
        if (ital != KtDimen.NULL) {
            width = width.plus(ital);
        }
        return new KtHBoxNode(new KtBoxSizes(node.getHeight(), width, node.getDepth(), node.getLeftX()), KtGlueSetting.NATURAL, new KtNodeList(node));
    }

    static {
        int i = 0;
        while (i < pTab.length) {
            KtTeXFontMetric.pTab[i++] = -1;
        }
        KtTeXFontMetric.pTab[0] = KtTeXFm.FP_SLANT;
        KtTeXFontMetric.pTab[1] = KtTeXFm.FP_SPACE;
        KtTeXFontMetric.pTab[2] = KtTeXFm.FP_STRETCH;
        KtTeXFontMetric.pTab[3] = KtTeXFm.FP_SHRINK;
        KtTeXFontMetric.pTab[4] = KtTeXFm.FP_X_HEIGHT;
        KtTeXFontMetric.pTab[5] = KtTeXFm.FP_QUAD;
        KtTeXFontMetric.pTab[6] = KtTeXFm.FP_EXTRA_SPACE;
        KtTeXFontMetric.pTab[7] = KtTeXMathSymFm.FP_MATH_X_HEIGHT;
        KtTeXFontMetric.pTab[8] = KtTeXMathSymFm.FP_MATH_QUAD;
        KtTeXFontMetric.pTab[9] = KtTeXMathSymFm.FP_NUM1;
        KtTeXFontMetric.pTab[10] = KtTeXMathSymFm.FP_NUM2;
        KtTeXFontMetric.pTab[11] = KtTeXMathSymFm.FP_NUM3;
        KtTeXFontMetric.pTab[12] = KtTeXMathSymFm.FP_DENOM1;
        KtTeXFontMetric.pTab[13] = KtTeXMathSymFm.FP_DENOM2;
        KtTeXFontMetric.pTab[14] = KtTeXMathSymFm.FP_SUP1;
        KtTeXFontMetric.pTab[15] = KtTeXMathSymFm.FP_SUP2;
        KtTeXFontMetric.pTab[16] = KtTeXMathSymFm.FP_SUP3;
        KtTeXFontMetric.pTab[17] = KtTeXMathSymFm.FP_SUB1;
        KtTeXFontMetric.pTab[18] = KtTeXMathSymFm.FP_SUB2;
        KtTeXFontMetric.pTab[19] = KtTeXMathSymFm.FP_SUP_DROP;
        KtTeXFontMetric.pTab[20] = KtTeXMathSymFm.FP_SUB_DROP;
        KtTeXFontMetric.pTab[21] = KtTeXMathSymFm.FP_DELIM1;
        KtTeXFontMetric.pTab[22] = KtTeXMathSymFm.FP_DELIM2;
        KtTeXFontMetric.pTab[23] = KtTeXMathSymFm.FP_AXIS_HEIGHT;
        KtTeXFontMetric.pTab[24] = KtTeXMathExtFm.FP_DEFAULT_RULE_THICKNESS;
        KtTeXFontMetric.pTab[25] = KtTeXMathExtFm.FP_BIG_OP_SPACING1;
        KtTeXFontMetric.pTab[26] = KtTeXMathExtFm.FP_BIG_OP_SPACING2;
        KtTeXFontMetric.pTab[27] = KtTeXMathExtFm.FP_BIG_OP_SPACING3;
        KtTeXFontMetric.pTab[28] = KtTeXMathExtFm.FP_BIG_OP_SPACING4;
        KtTeXFontMetric.pTab[29] = KtTeXMathExtFm.FP_BIG_OP_SPACING5;
    }

    protected class KtCharNode
    extends KtAnyNode {
        private final KtCharCode code;

        public KtCharNode(KtDimen w, KtDimen h, KtDimen d, KtCharCode c) {
            super(w, h, d);
            this.code = c;
        }

        @Override
        public short getIdx() {
            return (short)this.code.toChar();
        }

        @Override
        public void finishAddOn(KtLog log) {
            log.add(this.code);
        }

        @Override
        public void finishShortlyAddOn(KtLog log) {
            log.add(this.code);
        }

        @Override
        public void typeSet(KtTypesetter setter, KtSettingContext sctx) {
            setter.set(this.code, (KtFontMetric)KtTeXFontMetric.this);
        }

        @Override
        public byte beforeWord() {
            return this.code.toCanonicalLetter() != '\uffff' ? (byte)2 : 1;
        }

        @Override
        public boolean canBePartOfWord() {
            return this.code.toCanonicalLetter() != '\uffff';
        }

        @Override
        public void contributeCharCodes(KtName.KtBuffer buf) {
            buf.append(this.code);
        }

        @Override
        public boolean providesRebuilder(boolean prev) {
            return true;
        }

        @Override
        public KtWordRebuilder makeRebuilder(KtTreatNode proc, boolean prev) {
            return prev ? new KtLigKernBuilder(this.code, proc) : new KtLigKernBuilder(false, proc);
        }

        public String toString() {
            return "KtChar(" + String.valueOf(this.code) + ")";
        }
    }

    protected class KtLigKernBuilder
    extends KtTeXLigKernBuilder {
        protected final KtTreatNode proc;
        protected final boolean discs;
        protected final boolean zeroKerns;

        public KtLigKernBuilder(boolean leftBoundary, KtTreatNode proc, boolean discs, boolean zeroKerns) {
            super(leftBoundary);
            this.proc = proc;
            this.discs = discs;
            this.zeroKerns = zeroKerns;
        }

        public KtLigKernBuilder(boolean leftBoundary, KtTreatNode proc) {
            this(leftBoundary, proc, false, false);
        }

        private KtLigKernBuilder(KtCharCode code, KtTreatNode proc) {
            super(code);
            this.proc = proc;
            this.discs = false;
            this.zeroKerns = false;
        }

        private KtLigKernBuilder(short index, KtName subst, boolean leftHit, KtTreatNode proc) {
            super(index, subst, leftHit);
            this.proc = proc;
            this.discs = false;
            this.zeroKerns = false;
        }

        @Override
        protected boolean exists(short index) {
            return KtTeXFontMetric.this.tfm.getCharInfo(index) != KtTeXFm.KtCharInfo.NULL;
        }

        @Override
        protected KtTeXFm.KtLigKern getLigKern(short left, short right) {
            return KtTeXFontMetric.this.tfm.getLigKern(left, right);
        }

        @Override
        protected void makeChar(KtCharCode code) {
            KtTeXFm.KtCharInfo info = KtTeXFontMetric.this.tfm.getCharInfo((short)code.toChar());
            if (info != KtTeXFm.KtCharInfo.NULL) {
                this.proc.execute(new KtCharNode(KtTeXFontMetric.this.atSize.times(info.getWidth()), KtTeXFontMetric.this.atSize.times(info.getHeight()), KtTeXFontMetric.this.atSize.times(info.getDepth()), code));
            }
            this.makeDisc(code);
        }

        @Override
        protected void makeLig(short lig, KtName subst, boolean lh, boolean rh) {
            int l;
            KtTeXFm.KtCharInfo info = KtTeXFontMetric.this.tfm.getCharInfo(lig);
            if (info != KtTeXFm.KtCharInfo.NULL) {
                this.proc.execute(new KtLigNode(KtTeXFontMetric.this.atSize.times(info.getWidth()), KtTeXFontMetric.this.atSize.times(info.getHeight()), KtTeXFontMetric.this.atSize.times(info.getDepth()), lig, subst, lh, rh));
            }
            if ((l = subst.length()) > 0) {
                this.makeDisc(subst.codeAt(l - 1));
            }
        }

        @Override
        protected void makeKern(KtBinFraction kern) {
            KtDimen dim = KtTeXFontMetric.this.atSize.times(kern);
            if (this.zeroKerns || !dim.isZero()) {
                this.proc.execute(new KtChrKernNode(dim));
            }
        }

        private void makeDisc(KtCharCode last) {
            KtNum num;
            if (this.discs && (num = KtTeXFontMetric.this.getNumParam(0)) != KtNum.NULL && last.match(num)) {
                this.proc.execute(KtDiscretionaryNode.EMPTY);
            }
        }

        @Override
        protected KtNode makeChar(KtCharCode code, boolean larger) {
            return larger ? KtTeXFontMetric.this.getLargerNode(code) : KtTeXFontMetric.this.getCharNode(code);
        }

        @Override
        protected KtNode makeLig(short lig, KtName subst, boolean lh, boolean rh, boolean larger) {
            throw new RuntimeException("larger ligatures not supported");
        }
    }

    protected class KtMathLigKernBuilder
    extends KtLigKernBuilder {
        public KtMathLigKernBuilder(KtTreatNode proc) {
            super(false, proc, false, true);
        }

        @Override
        protected void makeLig(short lig, KtName subst, boolean lh, boolean rh) {
            KtTeXFm.KtCharInfo info = KtTeXFontMetric.this.tfm.getCharInfo(lig);
            if (info != KtTeXFm.KtCharInfo.NULL) {
                this.proc.execute(KtTeXFontMetric.this.indexNode(lig, info));
            }
        }

        @Override
        protected KtNode makeLig(short lig, KtName subst, boolean lh, boolean rh, boolean larger) {
            KtNode node = KtNode.NULL;
            KtTeXFm.KtCharInfo info = KtTeXFontMetric.this.tfm.getCharInfo(lig);
            if (info != KtTeXFm.KtCharInfo.NULL) {
                node = larger ? KtTeXFontMetric.this.largerNode(lig, info) : KtTeXFontMetric.this.indexNode(lig, info);
            }
            return node;
        }
    }

    protected class KtIndexNode
    extends KtAnyNode {
        private final short index;

        public KtIndexNode(KtDimen w, KtDimen h, KtDimen d, short i) {
            super(w, h, d);
            this.index = i;
        }

        @Override
        public short getIdx() {
            return this.index;
        }

        @Override
        public void finishAddOn(KtLog log) {
            log.add((char)this.index);
        }

        @Override
        public void finishShortlyAddOn(KtLog log) {
            log.add((char)this.index);
        }

        @Override
        public void typeSet(KtTypesetter setter, KtSettingContext sctx) {
            setter.set((char)this.index, (KtFontMetric)KtTeXFontMetric.this);
        }

        public String toString() {
            return "Index(" + this.index + ")";
        }
    }

    protected class KtLigNode
    extends KtAnyNode {
        private final short index;
        private final KtName subst;
        private final boolean leftHit;
        private final boolean rightHit;

        public KtLigNode(KtDimen w, KtDimen h, KtDimen d, short i, KtName s, boolean lh, boolean rh) {
            super(w, h, d);
            this.index = i;
            this.subst = s;
            this.leftHit = lh;
            this.rightHit = rh;
        }

        @Override
        public short getIdx() {
            return this.index;
        }

        @Override
        public void finishAddOn(KtLog log) {
            log.add((char)this.index).add(" (ligature ");
            if (this.leftHit) {
                log.add('|');
            }
            log.add(this.subst);
            if (this.rightHit) {
                log.add('|');
            }
            log.add(')');
        }

        @Override
        public void finishShortlyAddOn(KtLog log) {
            log.add(this.subst);
        }

        @Override
        public void typeSet(KtTypesetter setter, KtSettingContext sctx) {
            setter.set((char)this.index, (KtFontMetric)KtTeXFontMetric.this);
        }

        @Override
        public byte beforeWord() {
            return (byte)(this.subst.length() > 0 && this.subst.codeAt(0).toCanonicalLetter() != '\uffff' ? 2 : 1);
        }

        @Override
        public boolean canBePartOfWord() {
            for (int i = 0; i < this.subst.length(); ++i) {
                if (this.subst.codeAt(i).toCanonicalLetter() != '\uffff') continue;
                return false;
            }
            return true;
        }

        @Override
        public void contributeCharCodes(KtName.KtBuffer buf) {
            buf.append(this.subst);
        }

        @Override
        public boolean rightBoundary() {
            return this.rightHit;
        }

        @Override
        public boolean providesRebuilder(boolean prev) {
            return true;
        }

        @Override
        public KtWordRebuilder makeRebuilder(KtTreatNode proc, boolean prev) {
            return !prev && !this.leftHit ? new KtLigKernBuilder(false, proc) : (!this.leftHit || prev && this.subst.length() > 0 ? new KtLigKernBuilder(this.index, this.subst, this.leftHit, proc) : new KtLigKernBuilder(true, proc));
        }

        public String toString() {
            return "Lig(" + this.index + "; " + String.valueOf(this.subst) + "; " + this.leftHit + "; " + this.rightHit + ")";
        }
    }

    protected abstract class KtAnyNode
    extends KtBaseNode {
        private final KtDimen width;
        private final KtDimen height;
        private final KtDimen depth;

        public KtAnyNode(KtDimen w, KtDimen h, KtDimen d) {
            this.width = w;
            this.height = h;
            this.depth = d;
        }

        @Override
        public KtDimen getWidth() {
            return this.width;
        }

        @Override
        public KtDimen getLeftX() {
            return KtDimen.ZERO;
        }

        @Override
        public KtDimen getHeight() {
            return this.height;
        }

        @Override
        public KtDimen getDepth() {
            return this.depth;
        }

        @Override
        protected boolean allegedlyVisible() {
            return true;
        }

        public final KtFontMetric getFontMetric() {
            return KtTeXFontMetric.this;
        }

        @Override
        public void addOn(KtLog log, KtCntxLog cntx) {
            KtTeXFontMetric.this.getIdent().addEscapedOn(log);
            log.add(' ');
            this.finishAddOn(log);
        }

        @Override
        public KtFontMetric addShortlyOn(KtLog log, KtFontMetric metric) {
            if (!KtTeXFontMetric.this.equals(metric)) {
                KtTeXFontMetric.this.getIdent().addEscapedOn(log);
                log.add(' ');
                metric = KtTeXFontMetric.this;
            }
            this.finishShortlyAddOn(log);
            return metric;
        }

        @Override
        public KtDimen getItalCorr() {
            KtTeXFm.KtCharInfo info = KtTeXFontMetric.this.tfm.getCharInfo(this.getIdx());
            return info != KtTeXFm.KtCharInfo.NULL ? KtTeXFontMetric.this.atSize.times(info.getItalic()) : KtDimen.NULL;
        }

        public abstract short getIdx();

        public abstract void finishAddOn(KtLog var1);

        public abstract void finishShortlyAddOn(KtLog var1);

        @Override
        public boolean canBePartOfDiscretionary() {
            return true;
        }

        @Override
        public boolean kernAfterCanBeSpared() {
            return true;
        }

        @Override
        public KtFontMetric uniformMetric() {
            return KtTeXFontMetric.this;
        }

        @Override
        public byte afterWord() {
            return 1;
        }
    }
}

