/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.command.KtPrim;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.node.KtInsertNode;
import com.whitemagicsoftware.keentype.node.KtInsertion;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtVBoxNode;
import com.whitemagicsoftware.keentype.typo.KtBuilderPrim;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;
import com.whitemagicsoftware.keentype.typo.KtVertGroup;

public class KtInsertPrim
extends KtBuilderPrim {
    public static final int INTP_FLOATING_PENALTY = KtInsertPrim.newIntParam();

    public KtInsertPrim(String name) {
        super(name);
    }

    @Override
    public void exec(KtBuilder bld, KtToken src) {
        int outBoxNum;
        int num = KtPrim.scanRegisterCode();
        if (num == (outBoxNum = KtInsertPrim.getConfig().getIntParam(INTP_OUTPUT_BOX_NUM))) {
            num = 0;
            KtInsertPrim.error("CantInsertOutbox", this, KtInsertPrim.num(outBoxNum), KtInsertPrim.num(num));
        }
        KtInsertPrim.pushLevel(new KtInsertGroup(num));
        KtInsertPrim.scanLeftBrace();
    }

    public static class KtInsertGroup
    extends KtVertGroup {
        private final int num;
        private KtGlue topSkip;
        private KtDimen maxDepth;
        private int floatCost;

        protected KtInsertGroup(int num) {
            this.num = num;
        }

        @Override
        public void stop() {
            super.stop();
            this.topSkip = KtInsertGroup.getConfig().getGlueParam(KtTypoCommand.GLUEP_SPLIT_TOP_SKIP);
            this.maxDepth = KtInsertGroup.getConfig().getDimParam(KtTypoCommand.DIMP_SPLIT_MAX_DEPTH);
            this.floatCost = KtInsertGroup.getConfig().getIntParam(INTP_FLOATING_PENALTY);
        }

        @Override
        public void close() {
            super.close();
            KtNodeList list = this.builder.getList();
            KtVBoxNode vbox = KtVBoxNode.packedOf(list);
            KtDimen size = vbox.getHeight().plus(vbox.getDepth());
            KtBuilder bld = KtTypoCommand.getBld();
            bld.addNode(new KtInsertNode(new KtInsertion(this.num, list, size, this.topSkip, this.maxDepth, KtNum.valueOf(this.floatCost))));
            bld.buildPage();
        }
    }
}

